/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.preparator.packet;

import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.packet.ZeroRTTPacket;
import de.rub.nds.tlsattacker.core.quic.preparator.packet.LongHeaderPacketPreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZeroRTTPacketPreparator
extends LongHeaderPacketPreparator<ZeroRTTPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ZeroRTTPacketPreparator(Chooser chooser, ZeroRTTPacket packet) {
        super(chooser, packet);
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing 0-RTT Packet");
        this.prepareUnprotectedPacketNumber();
        this.preparePacketNumberLength();
        this.prepareUnprotectedFlags();
        this.prepareLongHeaderPacket();
    }

    private void prepareUnprotectedPacketNumber() {
        if (((ZeroRTTPacket)this.packet).getUnprotectedPacketNumber() == null) {
            ((ZeroRTTPacket)this.packet).setUnprotectedPacketNumber(this.context.getOneRTTPacketPacketNumber());
            this.context.setOneRTTPacketPacketNumber(this.context.getOneRTTPacketPacketNumber() + 1);
        }
        LOGGER.debug("Unprotected Packet Number: {}", ((ZeroRTTPacket)this.packet).getUnprotectedPacketNumber().getValue());
    }

    private void prepareUnprotectedFlags() {
        byte packetType = QuicPacketType.ZERO_RTT_PACKET.getHeader(this.context.getQuicVersion());
        int packetNumber = (Integer)((ZeroRTTPacket)this.packet).getPacketNumberLength().getValue();
        ((ZeroRTTPacket)this.packet).setUnprotectedFlags((byte)(packetType ^ packetNumber - 1));
        LOGGER.debug("Unprotected Flags: {}", ((ZeroRTTPacket)this.packet).getUnprotectedFlags().getValue());
    }
}

