/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.frame;

import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.frame.AckFrame;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.QuicFrameSerializer;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AckFrameSerializer
extends QuicFrameSerializer<AckFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public AckFrameSerializer(AckFrame frame) {
        super(frame);
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeFrameType();
        this.writeLargestAcknowledged();
        this.writeAckDelay();
        this.writeAckRangeCount();
        this.writeFirstAckRange();
        QuicFrameType frameType = QuicFrameType.getFrameType((Long)((AckFrame)this.frame).getFrameType().getValue());
        if (frameType == QuicFrameType.ACK_FRAME_WITH_ECN) {
            this.writeEcnCounts();
        }
        return this.getAlreadySerialized();
    }

    private void writeLargestAcknowledged() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((AckFrame)this.frame).getLargestAcknowledged().getValue()));
        LOGGER.debug("Largest Acknowledged: {}", ((AckFrame)this.frame).getLargestAcknowledged().getValue());
    }

    private void writeAckDelay() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((AckFrame)this.frame).getAckDelay().getValue()));
        LOGGER.debug("ACK Delay: {}", ((AckFrame)this.frame).getAckDelay().getValue());
    }

    private void writeAckRangeCount() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((AckFrame)this.frame).getAckRangeCount().getValue()));
        LOGGER.debug("ACK Range Count: {}", ((AckFrame)this.frame).getAckRangeCount().getValue());
    }

    private void writeFirstAckRange() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((AckFrame)this.frame).getFirstACKRange().getValue()));
        LOGGER.debug("First ACK Range: {}", ((AckFrame)this.frame).getFirstACKRange().getValue());
    }

    private void writeEcnCounts() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((AckFrame)this.frame).getEct0().getValue()));
        LOGGER.debug("ECT0 Count: {}", ((AckFrame)this.frame).getEct0().getValue());
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((AckFrame)this.frame).getEct1().getValue()));
        LOGGER.debug("ECT1 Count: {}", ((AckFrame)this.frame).getEct1().getValue());
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((AckFrame)this.frame).getEcnCe().getValue()));
        LOGGER.debug("ECT-CE Count: {}", ((AckFrame)this.frame).getEcnCe().getValue());
    }
}

