/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.frame;

import de.rub.nds.tlsattacker.core.quic.frame.CryptoFrame;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.QuicFrameSerializer;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptoFrameSerializer
extends QuicFrameSerializer<CryptoFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CryptoFrameSerializer(CryptoFrame frame) {
        super(frame);
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeFrameType();
        this.writeFrameOffset();
        this.writeFrameLength();
        this.writeFrameCryptoData();
        return this.getAlreadySerialized();
    }

    protected void writeFrameOffset() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((CryptoFrame)this.frame).getOffset().getValue()));
        LOGGER.debug("Offset: {}", ((CryptoFrame)this.frame).getOffset().getValue());
    }

    protected void writeFrameCryptoData() {
        this.appendBytes((byte[])((CryptoFrame)this.frame).getCryptoData().getValue());
        LOGGER.debug("Length: {}", ((CryptoFrame)this.frame).getLength().getValue());
    }

    protected void writeFrameLength() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((CryptoFrame)this.frame).getLength().getValue()));
        LOGGER.debug("Crypto Data: {}", ((CryptoFrame)this.frame).getCryptoData().getValue());
    }
}

