/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.frame;

import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.frame.DatagramFrame;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.QuicFrameSerializer;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatagramFrameSerializer
extends QuicFrameSerializer<DatagramFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public DatagramFrameSerializer(DatagramFrame frame) {
        super(frame);
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeFrameType();
        QuicFrameType frameType = QuicFrameType.getFrameType((Long)((DatagramFrame)this.frame).getFrameType().getValue());
        if (frameType == QuicFrameType.DATAGRAM_FRAME_LEN) {
            this.writeLength();
        }
        this.writeData();
        return this.getAlreadySerialized();
    }

    private void writeLength() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)((DatagramFrame)this.frame).getLength().getValue()).intValue()));
        LOGGER.debug("Length: {}", ((DatagramFrame)this.frame).getLength().getValue());
    }

    private void writeData() {
        this.appendBytes((byte[])((DatagramFrame)this.frame).getData().getValue());
        LOGGER.debug("Data: {}", ((DatagramFrame)this.frame).getData().getValue());
    }
}

