/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.frame;

import de.rub.nds.tlsattacker.core.quic.frame.NewConnectionIdFrame;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.QuicFrameSerializer;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewConnectionIdFrameSerializer
extends QuicFrameSerializer<NewConnectionIdFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public NewConnectionIdFrameSerializer(NewConnectionIdFrame frame) {
        super(frame);
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeFrameType();
        this.writeSequenceNumber();
        this.writeRetirePriorTo();
        this.writeConnectionIdLength();
        this.writeConnectionId();
        this.writeStatelessResetToken();
        return this.getAlreadySerialized();
    }

    protected void writeSequenceNumber() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((NewConnectionIdFrame)this.frame).getSequenceNumber().getValue()));
        LOGGER.debug("Sequence  Number: {}", ((NewConnectionIdFrame)this.frame).getSequenceNumber().getValue());
    }

    protected void writeRetirePriorTo() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((NewConnectionIdFrame)this.frame).getRetirePriorTo().getValue()));
        LOGGER.debug("Retire Prior To: {}", ((NewConnectionIdFrame)this.frame).getRetirePriorTo().getValue());
    }

    protected void writeConnectionIdLength() {
        if ((Integer)((NewConnectionIdFrame)this.frame).getConnectionIdLength().getValue() > 255) {
            LOGGER.warn("Connection ID length exceeds maximum length encodable in NEW_CONNECTION_ID frame.");
        }
        this.appendInt((Integer)((NewConnectionIdFrame)this.frame).getConnectionIdLength().getValue(), 1);
        LOGGER.debug("Length: {}", ((NewConnectionIdFrame)this.frame).getConnectionIdLength().getValue());
    }

    protected void writeConnectionId() {
        this.appendBytes((byte[])((NewConnectionIdFrame)this.frame).getConnectionId().getValue());
        LOGGER.debug("Connection ID: {}", ((NewConnectionIdFrame)this.frame).getConnectionId().getValue());
    }

    protected void writeStatelessResetToken() {
        this.appendBytes((byte[])((NewConnectionIdFrame)this.frame).getStatelessResetToken().getValue());
        LOGGER.debug("Stateless Reset Token: {}", ((NewConnectionIdFrame)this.frame).getStatelessResetToken().getValue());
    }
}

