/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.frame;

import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class QuicFrameSerializer<T extends QuicFrame>
extends Serializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final T frame;

    public QuicFrameSerializer(T frame) {
        this.frame = frame;
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeFrameType();
        return this.getAlreadySerialized();
    }

    protected void writeFrameType() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger((Long)((QuicFrame)this.frame).getFrameType().getValue()));
        LOGGER.debug("Frame Type: {}", ((QuicFrame)this.frame).getFrameType().getValue());
    }
}

