/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.frame;

import de.rub.nds.tlsattacker.core.quic.frame.ResetStreamFrame;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.QuicFrameSerializer;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResetStreamFrameSerializer
extends QuicFrameSerializer<ResetStreamFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ResetStreamFrameSerializer(ResetStreamFrame frame) {
        super(frame);
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeFrameType();
        this.writeStreamId();
        this.writeApplicationProtocolErrorCode();
        this.writeFinalSize();
        return this.getAlreadySerialized();
    }

    private void writeStreamId() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)((ResetStreamFrame)this.frame).getStreamId().getValue()).intValue()));
        LOGGER.debug("Stream ID: {}", ((ResetStreamFrame)this.frame).getStreamId().getValue());
    }

    private void writeApplicationProtocolErrorCode() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)((ResetStreamFrame)this.frame).getApplicationProtocolErrorCode().getValue()).intValue()));
        LOGGER.debug("Application Protocol Error Code: {}", ((ResetStreamFrame)this.frame).getApplicationProtocolErrorCode().getValue());
    }

    protected void writeFinalSize() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)((ResetStreamFrame)this.frame).getFinalSize().getValue()).intValue()));
        LOGGER.debug("Final Size: {}", ((ResetStreamFrame)this.frame).getFinalSize().getValue());
    }
}

