/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.packet;

import de.rub.nds.tlsattacker.core.quic.packet.InitialPacket;
import de.rub.nds.tlsattacker.core.quic.serializer.packet.LongHeaderPacketSerializer;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InitialPacketSerializer
extends LongHeaderPacketSerializer<InitialPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public InitialPacketSerializer(InitialPacket packet) {
        super(packet);
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeProtectedFlags((InitialPacket)this.packet);
        this.writeQuicVersion((InitialPacket)this.packet);
        this.writeDestinationConnectionIdLength((InitialPacket)this.packet);
        this.writeDestinationConnectionId((InitialPacket)this.packet);
        this.writeSourceConnectionIdLength((InitialPacket)this.packet);
        this.writeSourceConnectionId((InitialPacket)this.packet);
        this.writeTokenLength((InitialPacket)this.packet);
        this.writeToken((InitialPacket)this.packet);
        this.writePacketLength((InitialPacket)this.packet);
        this.writeProtectedPacketNumber((InitialPacket)this.packet);
        this.writeProtectedPayload((InitialPacket)this.packet);
        return this.getAlreadySerialized();
    }

    protected void writeTokenLength(InitialPacket packet) {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)packet.getTokenLength().getValue()).intValue()));
        LOGGER.debug("Token Length: {}", packet.getTokenLength().getValue());
    }

    protected void writeToken(InitialPacket packet) {
        if (packet.getToken() != null) {
            this.appendBytes((byte[])packet.getToken().getValue());
            LOGGER.debug("Token: {}", packet.getToken().getValue());
        }
    }
}

