/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.packet;

import de.rub.nds.tlsattacker.core.quic.packet.LongHeaderPacket;
import de.rub.nds.tlsattacker.core.quic.serializer.packet.QuicPacketSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LongHeaderPacketSerializer<T extends LongHeaderPacket>
extends QuicPacketSerializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public LongHeaderPacketSerializer(T packet) {
        super(packet);
    }

    protected void writeSourceConnectionIdLength(T packet) {
        this.appendByte((Byte)((LongHeaderPacket)packet).getSourceConnectionIdLength().getValue());
        LOGGER.debug("Source Connection ID Length: {}", ((LongHeaderPacket)packet).getSourceConnectionIdLength().getValue());
    }

    protected void writeSourceConnectionId(T packet) {
        this.appendBytes((byte[])((LongHeaderPacket)packet).getSourceConnectionId().getValue());
        LOGGER.debug("Source Connection ID: {}", ((LongHeaderPacket)packet).getSourceConnectionId().getValue());
    }

    protected void writeQuicVersion(T packet) {
        this.appendBytes((byte[])((LongHeaderPacket)packet).getQuicVersion().getValue());
        LOGGER.debug("Quic Version: {}", ((LongHeaderPacket)packet).getSourceConnectionId().getValue());
    }
}

