/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.packet;

import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class QuicPacketSerializer<T extends QuicPacket>
extends Serializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final T packet;

    public QuicPacketSerializer(T packet) {
        this.packet = packet;
    }

    protected void writeProtectedFlags(T packet) {
        this.appendByte((Byte)((QuicPacket)packet).getProtectedFlags().getValue());
        LOGGER.debug("Protected Flags: {}", ((QuicPacket)packet).getProtectedFlags().getValue());
    }

    protected void writeDestinationConnectionIdLength(T packet) {
        this.appendByte((Byte)((QuicPacket)packet).getDestinationConnectionIdLength().getValue());
        LOGGER.debug("Destination Connection ID Length: {}", ((QuicPacket)packet).getDestinationConnectionIdLength().getValue());
    }

    protected void writeDestinationConnectionId(T packet) {
        this.appendBytes((byte[])((QuicPacket)packet).getDestinationConnectionId().getValue());
        LOGGER.debug("Destination Connection ID: {}", ((QuicPacket)packet).getDestinationConnectionId().getValue());
    }

    protected void writeProtectedPacketNumber(T packet) {
        this.appendBytes((byte[])((QuicPacket)packet).getProtectedPacketNumber().getValue());
        LOGGER.debug("Protected Packet Number: {}", ((QuicPacket)packet).getProtectedPacketNumber().getValue());
    }

    protected void writePacketLength(T packet) {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)((QuicPacket)packet).getPacketLength().getValue()).intValue()));
        LOGGER.debug("Packet Length: {}", ((QuicPacket)packet).getPacketLength().getValue());
    }

    protected void writeProtectedPayload(T packet) {
        this.appendBytes((byte[])((QuicPacket)packet).getProtectedPayload().getValue());
        LOGGER.debug("Protected Payload: {}", ((QuicPacket)packet).getProtectedPayload().getValue());
    }
}

