/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.packet;

import de.rub.nds.tlsattacker.core.quic.packet.RetryPacket;
import de.rub.nds.tlsattacker.core.quic.serializer.packet.LongHeaderPacketSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RetryPacketSerializer
extends LongHeaderPacketSerializer<RetryPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public RetryPacketSerializer(RetryPacket packet) {
        super(packet);
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeUnprotectedFlags((RetryPacket)this.packet);
        this.writeQuicVersion((RetryPacket)this.packet);
        this.writeDestinationConnectionIdLength((RetryPacket)this.packet);
        this.writeDestinationConnectionId((RetryPacket)this.packet);
        this.writeSourceConnectionIdLength((RetryPacket)this.packet);
        this.writeSourceConnectionId((RetryPacket)this.packet);
        this.writeRetryToken((RetryPacket)this.packet);
        this.writeRetryIntegrityTag((RetryPacket)this.packet);
        return this.getAlreadySerialized();
    }

    protected void writeUnprotectedFlags(RetryPacket packet) {
        this.appendByte((Byte)packet.getUnprotectedFlags().getValue());
        LOGGER.debug("Unprotected Flags: {}", packet.getUnprotectedFlags().getValue());
    }

    protected void writeRetryToken(RetryPacket packet) {
        if (packet.getRetryToken() != null) {
            this.appendBytes((byte[])packet.getRetryToken().getValue());
            LOGGER.debug("Retry Token: {}", packet.getRetryToken().getValue());
        }
    }

    protected void writeRetryIntegrityTag(RetryPacket packet) {
        if (packet.getRetryIntegrityTag() != null) {
            this.appendBytes((byte[])packet.getRetryIntegrityTag().getValue());
            LOGGER.debug("Retry Integrity Tag: {}", packet.getRetryIntegrityTag().getValue());
        }
    }
}

