/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import java.util.Objects;

public class RecordCryptoComputations
extends ModifiableVariableHolder {
    private ModifiableByteArray cipherKey;
    private ModifiableByteArray macKey;
    private ModifiableByteArray mac;
    private ModifiableByteArray aeadSalt;
    private ModifiableByteArray explicitNonce;
    private ModifiableByteArray gcmNonce;
    private ModifiableByteArray padding;
    private ModifiableInteger additionalPaddingLength;
    private ModifiableByteArray plainRecordBytes;
    private ModifiableByteArray authenticatedNonMetaData;
    private ModifiableByteArray ciphertext;
    private ModifiableByteArray cbcInitialisationVector;
    private ModifiableByteArray authenticatedMetaData;
    private ModifiableByteArray authenticationTag;
    private Boolean paddingValid = null;
    private Boolean macValid = null;
    private Boolean authenticationTagValid = null;
    private Tls13KeySetType usedTls13KeySetType = Tls13KeySetType.NONE;

    public void reset() {
        super.reset();
        this.paddingValid = null;
        this.macValid = null;
        this.authenticationTagValid = null;
    }

    public ModifiableByteArray getCipherKey() {
        return this.cipherKey;
    }

    public void setCipherKey(ModifiableByteArray cipherKey) {
        this.cipherKey = cipherKey;
    }

    public void setCipherKey(byte[] cipherKey) {
        this.cipherKey = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cipherKey, (byte[])cipherKey);
    }

    public ModifiableByteArray getMacKey() {
        return this.macKey;
    }

    public void setMacKey(ModifiableByteArray macKey) {
        this.macKey = macKey;
    }

    public void setMacKey(byte[] macKey) {
        this.macKey = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.macKey, (byte[])macKey);
    }

    public ModifiableByteArray getMac() {
        return this.mac;
    }

    public void setMac(ModifiableByteArray mac) {
        this.mac = mac;
    }

    public void setMac(byte[] mac) {
        this.mac = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.mac, (byte[])mac);
    }

    public ModifiableByteArray getPadding() {
        return this.padding;
    }

    public void setPadding(ModifiableByteArray padding) {
        this.padding = padding;
    }

    public void setPadding(byte[] padding) {
        this.padding = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.padding, (byte[])padding);
    }

    public ModifiableByteArray getPlainRecordBytes() {
        return this.plainRecordBytes;
    }

    public void setPlainRecordBytes(ModifiableByteArray plainRecordBytes) {
        this.plainRecordBytes = plainRecordBytes;
    }

    public void setPlainRecordBytes(byte[] plainRecordBytes) {
        this.plainRecordBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.plainRecordBytes, (byte[])plainRecordBytes);
    }

    public ModifiableByteArray getCbcInitialisationVector() {
        return this.cbcInitialisationVector;
    }

    public void setCbcInitialisationVector(ModifiableByteArray cbcInitialisationVector) {
        this.cbcInitialisationVector = cbcInitialisationVector;
    }

    public void setCbcInitialisationVector(byte[] initialisationVector) {
        this.cbcInitialisationVector = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cbcInitialisationVector, (byte[])initialisationVector);
    }

    public ModifiableByteArray getAuthenticatedMetaData() {
        return this.authenticatedMetaData;
    }

    public void setAuthenticatedMetaData(ModifiableByteArray authenticatedMetaData) {
        this.authenticatedMetaData = authenticatedMetaData;
    }

    public void setAuthenticatedMetaData(byte[] authenticatedMetaData) {
        this.authenticatedMetaData = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.authenticatedMetaData, (byte[])authenticatedMetaData);
    }

    public ModifiableByteArray getAuthenticatedNonMetaData() {
        return this.authenticatedNonMetaData;
    }

    public void setAuthenticatedNonMetaData(ModifiableByteArray authenticatedNonMetaData) {
        this.authenticatedNonMetaData = authenticatedNonMetaData;
    }

    public void setAuthenticatedNonMetaData(byte[] authenticatedNonMetaData) {
        this.authenticatedNonMetaData = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.authenticatedNonMetaData, (byte[])authenticatedNonMetaData);
    }

    public ModifiableInteger getAdditionalPaddingLength() {
        return this.additionalPaddingLength;
    }

    public void setAdditionalPaddingLength(ModifiableInteger additionalPaddingLength) {
        this.additionalPaddingLength = additionalPaddingLength;
    }

    public void setAdditionalPaddingLength(Integer paddingLength) {
        this.additionalPaddingLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.additionalPaddingLength, (Integer)paddingLength);
    }

    public Boolean getPaddingValid() {
        return this.paddingValid;
    }

    public void setPaddingValid(Boolean paddingValid) {
        this.paddingValid = paddingValid;
    }

    public Boolean getMacValid() {
        return this.macValid;
    }

    public void setMacValid(Boolean macValid) {
        this.macValid = macValid;
    }

    public ModifiableByteArray getCiphertext() {
        return this.ciphertext;
    }

    public void setCiphertext(ModifiableByteArray ciphertext) {
        this.ciphertext = ciphertext;
    }

    public void setCiphertext(byte[] ciphertext) {
        this.ciphertext = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.ciphertext, (byte[])ciphertext);
    }

    public ModifiableByteArray getAeadSalt() {
        return this.aeadSalt;
    }

    public void setAeadSalt(ModifiableByteArray aeadSalt) {
        this.aeadSalt = aeadSalt;
    }

    public void setAeadSalt(byte[] aeadSalt) {
        this.aeadSalt = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.aeadSalt, (byte[])aeadSalt);
    }

    public ModifiableByteArray getExplicitNonce() {
        return this.explicitNonce;
    }

    public void setExplicitNonce(ModifiableByteArray explicitNonce) {
        this.explicitNonce = explicitNonce;
    }

    public void setExplicitNonce(byte[] explicitNonce) {
        this.explicitNonce = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.explicitNonce, (byte[])explicitNonce);
    }

    public ModifiableByteArray getGcmNonce() {
        return this.gcmNonce;
    }

    public void setGcmNonce(ModifiableByteArray gcmNonce) {
        this.gcmNonce = gcmNonce;
    }

    public void setGcmNonce(byte[] gcmNonce) {
        this.gcmNonce = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.gcmNonce, (byte[])gcmNonce);
    }

    public ModifiableByteArray getAuthenticationTag() {
        return this.authenticationTag;
    }

    public void setAuthenticationTag(ModifiableByteArray authenticationTag) {
        this.authenticationTag = authenticationTag;
    }

    public void setAuthenticationTag(byte[] authenticationTag) {
        this.authenticationTag = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.authenticationTag, (byte[])authenticationTag);
    }

    public Boolean getAuthenticationTagValid() {
        return this.authenticationTagValid;
    }

    public void setAuthenticationTagValid(Boolean authenticationTagValid) {
        this.authenticationTagValid = authenticationTagValid;
    }

    public void setAuthenticationTagValid(boolean authenticationTagValid) {
        this.authenticationTagValid = authenticationTagValid;
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + Objects.hashCode(this.cipherKey);
        hash = 31 * hash + Objects.hashCode(this.macKey);
        hash = 31 * hash + Objects.hashCode(this.mac);
        hash = 31 * hash + Objects.hashCode(this.aeadSalt);
        hash = 31 * hash + Objects.hashCode(this.explicitNonce);
        hash = 31 * hash + Objects.hashCode(this.gcmNonce);
        hash = 31 * hash + Objects.hashCode(this.padding);
        hash = 31 * hash + Objects.hashCode(this.additionalPaddingLength);
        hash = 31 * hash + Objects.hashCode(this.plainRecordBytes);
        hash = 31 * hash + Objects.hashCode(this.authenticatedNonMetaData);
        hash = 31 * hash + Objects.hashCode(this.ciphertext);
        hash = 31 * hash + Objects.hashCode(this.cbcInitialisationVector);
        hash = 31 * hash + Objects.hashCode(this.authenticatedMetaData);
        hash = 31 * hash + Objects.hashCode(this.authenticationTag);
        hash = 31 * hash + Objects.hashCode(this.paddingValid);
        hash = 31 * hash + Objects.hashCode(this.macValid);
        hash = 31 * hash + Objects.hashCode(this.authenticationTagValid);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RecordCryptoComputations other = (RecordCryptoComputations)((Object)obj);
        if (!Objects.equals(this.cipherKey, other.cipherKey)) {
            return false;
        }
        if (!Objects.equals(this.macKey, other.macKey)) {
            return false;
        }
        if (!Objects.equals(this.mac, other.mac)) {
            return false;
        }
        if (!Objects.equals(this.aeadSalt, other.aeadSalt)) {
            return false;
        }
        if (!Objects.equals(this.explicitNonce, other.explicitNonce)) {
            return false;
        }
        if (!Objects.equals(this.gcmNonce, other.gcmNonce)) {
            return false;
        }
        if (!Objects.equals(this.padding, other.padding)) {
            return false;
        }
        if (!Objects.equals(this.additionalPaddingLength, other.additionalPaddingLength)) {
            return false;
        }
        if (!Objects.equals(this.plainRecordBytes, other.plainRecordBytes)) {
            return false;
        }
        if (!Objects.equals(this.authenticatedNonMetaData, other.authenticatedNonMetaData)) {
            return false;
        }
        if (!Objects.equals(this.ciphertext, other.ciphertext)) {
            return false;
        }
        if (!Objects.equals(this.cbcInitialisationVector, other.cbcInitialisationVector)) {
            return false;
        }
        if (!Objects.equals(this.authenticatedMetaData, other.authenticatedMetaData)) {
            return false;
        }
        if (!Objects.equals(this.authenticationTag, other.authenticationTag)) {
            return false;
        }
        if (!Objects.equals(this.paddingValid, other.paddingValid)) {
            return false;
        }
        if (!Objects.equals(this.macValid, other.macValid)) {
            return false;
        }
        return Objects.equals(this.authenticationTagValid, other.authenticationTagValid);
    }

    public Tls13KeySetType getUsedTls13KeySetType() {
        return this.usedTls13KeySetType;
    }

    public void setUsedTls13KeySetType(Tls13KeySetType usedTls13KeySetType) {
        this.usedTls13KeySetType = usedTls13KeySetType;
    }
}

