/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.cipher;

import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;

public class CipherState {
    private ProtocolVersion protocolVersion;
    private CipherSuite cipherSuite;
    private KeySet keySet;
    private long writeSequenceNumber = 0L;
    private long readSequenceNumber = 0L;
    private byte[] connectionId = new byte[0];
    private Boolean encryptThenMac;

    public CipherState(ProtocolVersion protocolVersion, CipherSuite cipherSuite, KeySet keySet, Boolean encryptThenMac) {
        this.protocolVersion = protocolVersion;
        this.cipherSuite = cipherSuite;
        this.keySet = keySet;
        this.encryptThenMac = encryptThenMac;
        this.connectionId = null;
    }

    public CipherState(ProtocolVersion protocolVersion, CipherSuite cipherSuite, KeySet keySet, Boolean encryptThenMac, byte[] connectionId) {
        this.protocolVersion = protocolVersion;
        this.cipherSuite = cipherSuite;
        this.keySet = keySet;
        this.encryptThenMac = encryptThenMac;
        this.connectionId = connectionId;
    }

    public Boolean isEncryptThenMac() {
        return this.encryptThenMac;
    }

    public void setEncryptThenMac(Boolean encryptThenMac) {
        this.encryptThenMac = encryptThenMac;
    }

    public ProtocolVersion getVersion() {
        return this.protocolVersion;
    }

    public void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public void setCipherSuite(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    public KeySet getKeySet() {
        return this.keySet;
    }

    public void setKeySet(KeySet keySet) {
        this.keySet = keySet;
    }

    public long getWriteSequenceNumber() {
        return this.writeSequenceNumber;
    }

    public void setWriteSequenceNumber(long writeSequenceNumber) {
        this.writeSequenceNumber = writeSequenceNumber;
    }

    public void increaseWriteSequenceNumber() {
        ++this.writeSequenceNumber;
    }

    public long getReadSequenceNumber() {
        return this.readSequenceNumber;
    }

    public void setReadSequenceNumber(long readSequenceNumber) {
        this.readSequenceNumber = readSequenceNumber;
    }

    public void increaseReadSequenceNumber() {
        ++this.readSequenceNumber;
    }

    public byte[] getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(byte[] connectionId) {
        this.connectionId = connectionId;
    }

    public CipherAlgorithm getCipherAlg() {
        return this.cipherSuite.getCipherAlgorithm();
    }
}

