/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.cipher;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.crypto.cipher.CipherWrapper;
import de.rub.nds.tlsattacker.core.crypto.mac.MacWrapper;
import de.rub.nds.tlsattacker.core.crypto.mac.WrappedMac;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.RecordCryptoComputations;
import de.rub.nds.tlsattacker.core.record.cipher.CipherState;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RecordBlockCipher
extends RecordCipher {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean useExplicitIv;
    private WrappedMac readMac;
    private WrappedMac writeMac;

    public RecordBlockCipher(TlsContext tlsContext, CipherState state) {
        super(tlsContext, state);
        try {
            this.encryptCipher = CipherWrapper.getEncryptionCipher(this.getState().getCipherSuite(), this.getLocalConnectionEndType(), this.getState().getKeySet());
            this.decryptCipher = CipherWrapper.getDecryptionCipher(this.getState().getCipherSuite(), this.getLocalConnectionEndType(), this.getState().getKeySet());
            this.readMac = MacWrapper.getMac(this.getState().getVersion(), this.getState().getCipherSuite(), this.getState().getKeySet().getReadMacSecret(this.getLocalConnectionEndType()));
            this.writeMac = MacWrapper.getMac(this.getState().getVersion(), this.getState().getCipherSuite(), this.getState().getKeySet().getWriteMacSecret(this.getLocalConnectionEndType()));
            if (this.getState().getVersion().usesExplicitIv()) {
                this.useExplicitIv = true;
            } else {
                this.useExplicitIv = false;
                this.encryptCipher.setIv(this.getState().getKeySet().getWriteIv(this.getLocalConnectionEndType()));
                this.decryptCipher.setIv(this.getState().getKeySet().getReadIv(this.getLocalConnectionEndType()));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Unsupported Cipher suite:" + this.getState().getCipherSuite().name(), e);
        }
    }

    private byte[] calculateMac(byte[] data, ConnectionEndType connectionEndType) {
        LOGGER.debug("The MAC was calculated over the following data: {}", (Object)data);
        byte[] result = connectionEndType == this.getConnectionEndType() ? this.writeMac.calculateMac(data) : this.readMac.calculateMac(data);
        LOGGER.debug("MAC: {}", (Object)result);
        return result;
    }

    private byte[] encrypt(byte[] plaintext, byte[] iv) throws CryptoException {
        byte[] expandedPlaintext = this.expandToBlocksize(plaintext);
        byte[] ciphertext = this.encryptCipher.encrypt(iv, expandedPlaintext);
        if (!this.useExplicitIv) {
            this.encryptCipher.setIv(this.extractNextEncryptIv(ciphertext));
        }
        LOGGER.debug("EncryptIv: {}", (Object)this.encryptCipher.getIv());
        return ciphertext;
    }

    @Override
    public void encrypt(Record record) throws CryptoException {
        byte[] cleanBytes;
        if (record.getComputations() == null) {
            LOGGER.warn("Record computations are not prepared.");
            record.prepareComputations();
        }
        LOGGER.debug("Encrypting Record:");
        RecordCryptoComputations computations = record.getComputations();
        record.getComputations().setMacKey(this.getState().getKeySet().getWriteMacSecret(this.getConnectionEndType()));
        record.getComputations().setCipherKey(this.getState().getKeySet().getWriteKey(this.getConnectionEndType()));
        byte[] iv = this.getEncryptionIV();
        record.getComputations().setCbcInitialisationVector(iv);
        iv = (byte[])record.getComputations().getCbcInitialisationVector().getValue();
        if (this.getState().getVersion().isDTLS() && this.getState().getConnectionId() != null && this.getState().getConnectionId().length > 0) {
            cleanBytes = this.encapsulateRecordBytes(record);
            record.setContentType(ProtocolMessageType.TLS12_CID.getValue());
        } else {
            cleanBytes = (byte[])record.getCleanProtocolMessageBytes().getValue();
        }
        if (this.getState().isEncryptThenMac().booleanValue()) {
            computations.setPadding(this.calculatePadding(this.calculatePaddingLength(record, cleanBytes.length)));
            LOGGER.debug("Padding: {}", computations.getPadding().getValue());
            computations.setPlainRecordBytes(DataConverter.concatenate((byte[][])new byte[][]{cleanBytes, (byte[])computations.getPadding().getValue()}));
            LOGGER.debug("PlainRecordBytes: {}", computations.getPlainRecordBytes().getValue());
            byte[] ciphertext = this.encrypt((byte[])computations.getPlainRecordBytes().getValue(), iv);
            computations.setCiphertext(ciphertext);
            if (this.useExplicitIv) {
                computations.setAuthenticatedNonMetaData(DataConverter.concatenate((byte[][])new byte[][]{iv, (byte[])record.getComputations().getCiphertext().getValue()}));
            } else {
                computations.setAuthenticatedNonMetaData((byte[])record.getComputations().getCiphertext().getValue());
            }
            computations.setAuthenticatedMetaData(this.collectAdditionalAuthenticatedData(record, this.getState().getVersion()));
            computations.setMac(this.calculateMac(DataConverter.concatenate((byte[][])new byte[][]{(byte[])computations.getAuthenticatedMetaData().getValue(), (byte[])computations.getAuthenticatedNonMetaData().getValue()}), this.getLocalConnectionEndType()));
            if (this.useExplicitIv) {
                record.setProtocolMessageBytes(DataConverter.concatenate((byte[][])new byte[][]{iv, (byte[])computations.getCiphertext().getValue(), (byte[])computations.getMac().getValue()}));
            } else {
                record.setProtocolMessageBytes(DataConverter.concatenate((byte[][])new byte[][]{(byte[])computations.getCiphertext().getValue(), (byte[])computations.getMac().getValue()}));
            }
        } else {
            computations.setAuthenticatedNonMetaData(cleanBytes);
            computations.setAuthenticatedMetaData(this.collectAdditionalAuthenticatedData(record, this.getState().getVersion()));
            computations.setMac(this.calculateMac(DataConverter.concatenate((byte[][])new byte[][]{(byte[])computations.getAuthenticatedMetaData().getValue(), (byte[])computations.getAuthenticatedNonMetaData().getValue()}), this.getLocalConnectionEndType()));
            computations.setPadding(this.calculatePadding(this.calculatePaddingLength(record, cleanBytes.length + ((byte[])computations.getMac().getValue()).length)));
            LOGGER.debug("Padding: {}", computations.getPadding().getValue());
            record.getComputations().setPlainRecordBytes(DataConverter.concatenate((byte[][])new byte[][]{cleanBytes, (byte[])computations.getMac().getValue(), (byte[])computations.getPadding().getValue()}));
            LOGGER.debug("PlainRecordBytes: {}", computations.getPlainRecordBytes().getValue());
            computations.setCiphertext(this.encrypt((byte[])record.getComputations().getPlainRecordBytes().getValue(), iv));
            if (this.useExplicitIv) {
                record.setProtocolMessageBytes(DataConverter.concatenate((byte[][])new byte[][]{iv, (byte[])computations.getCiphertext().getValue()}));
            } else {
                record.setProtocolMessageBytes(computations.getCiphertext());
            }
        }
        computations.setPaddingValid(true);
        computations.setMacValid(true);
    }

    private byte[] extractNextEncryptIv(byte[] ciphertext) {
        return Arrays.copyOfRange(ciphertext, ciphertext.length - this.encryptCipher.getBlocksize(), ciphertext.length);
    }

    private byte[] expandToBlocksize(byte[] plaintext) {
        byte[] expandedPlaintext = plaintext;
        int blocksize = this.encryptCipher.getBlocksize();
        if (plaintext != null && blocksize > 0 && plaintext.length % blocksize != 0) {
            int numberOfBlocks = plaintext.length / blocksize + 1;
            expandedPlaintext = new byte[numberOfBlocks * blocksize];
            System.arraycopy(plaintext, 0, expandedPlaintext, 0, plaintext.length);
        }
        return expandedPlaintext;
    }

    public byte[] calculatePadding(int paddingLength) {
        paddingLength = Math.abs(paddingLength);
        byte[] padding = new byte[paddingLength];
        for (int i = 0; i < paddingLength; ++i) {
            padding[i] = (byte)(paddingLength - 1);
        }
        return padding;
    }

    public int calculatePaddingLength(Record record, int dataLength) {
        int additionalPadding = this.getDefaultAdditionalPadding();
        if (additionalPadding > 256) {
            LOGGER.warn("Additional padding is too big. setting it to max possible value");
            additionalPadding = 256;
        } else if (additionalPadding < 0) {
            LOGGER.warn("Additional padding is negative, setting it to 0");
            additionalPadding = 0;
        }
        record.getComputations().setAdditionalPaddingLength(additionalPadding);
        additionalPadding = (Integer)record.getComputations().getAdditionalPaddingLength().getValue();
        if (additionalPadding % this.encryptCipher.getBlocksize() != 0) {
            LOGGER.warn("Additional padding is not a multiple of the blocksize");
        }
        return this.encryptCipher.getBlocksize() - dataLength % this.encryptCipher.getBlocksize() + additionalPadding;
    }

    public byte[] getEncryptionIV() {
        if (this.useExplicitIv) {
            LOGGER.debug("Using explict IV");
            byte[] iv = new byte[this.getState().getCipherAlg().getNonceBytesFromHandshake()];
            this.getRandom().nextBytes(iv);
            return iv;
        }
        LOGGER.debug("Using implicit IV");
        byte[] tempIv = this.encryptCipher.getIv();
        if (tempIv == null) {
            LOGGER.debug("First IV - using from KeyBlock");
            ConnectionEndType localConEndType = this.getLocalConnectionEndType();
            return this.getState().getKeySet().getWriteIv(localConEndType);
        }
        return tempIv;
    }

    @Override
    public void decrypt(Record record) throws CryptoException {
        if (record.getComputations() == null) {
            LOGGER.warn("Record computations are not prepared.");
            record.prepareComputations();
        }
        LOGGER.debug("Decrypting Record");
        RecordCryptoComputations computations = record.getComputations();
        computations.setMacKey(this.getState().getKeySet().getReadMacSecret(this.getConnectionEndType()));
        computations.setCipherKey(this.getState().getKeySet().getReadKey(this.getConnectionEndType()));
        byte[] plaintext = (byte[])record.getProtocolMessageBytes().getValue();
        RecordCipher.PlaintextParser parser = new RecordCipher.PlaintextParser(this, plaintext);
        try {
            byte[] ciphertext;
            byte[] iv;
            if (this.useExplicitIv) {
                LOGGER.debug("Using explicit IV");
                iv = parser.parseByteArrayField(this.getState().getCipherAlg().getNonceBytesFromHandshake());
            } else {
                LOGGER.debug("Using implicit IV");
                iv = this.decryptCipher.getIv();
            }
            LOGGER.debug("Using IV: {}", (Object)iv);
            record.getComputations().setCbcInitialisationVector(iv);
            int macLength = this.readMac.getMacLength();
            byte[] hmac = null;
            if (this.getState().isEncryptThenMac().booleanValue()) {
                int toParseCiphertextLength = parser.getBytesLeft() - macLength;
                if (toParseCiphertextLength < 0) {
                    throw new CryptoException("Record too small");
                }
                ciphertext = parser.parseByteArrayField(toParseCiphertextLength);
                hmac = parser.parseByteArrayField(macLength);
            } else {
                ciphertext = parser.parseByteArrayField(parser.getBytesLeft());
            }
            computations.setCiphertext(ciphertext);
            byte[] plainData = this.decryptCipher.decrypt(iv, (byte[])computations.getCiphertext().getValue());
            computations.setPlainRecordBytes(plainData);
            plainData = (byte[])computations.getPlainRecordBytes().getValue();
            LOGGER.debug("Decrypted plaintext: {}", (Object)plainData);
            int paddingLength = (plainData[plainData.length - 1] & 0xFF) + 1;
            if (plainData.length - paddingLength < 0) {
                LOGGER.warn("Error while decrypting record. Padding length is wrong.");
                record.setCleanProtocolMessageBytes(plainData);
                return;
            }
            byte[] padding = Arrays.copyOfRange(plainData, plainData.length - paddingLength, plainData.length);
            computations.setPadding(padding);
            computations.setPaddingValid(this.isPaddingValid(padding));
            int cleanProtocolBytesLength = this.getState().isEncryptThenMac() != false ? plainData.length - paddingLength : plainData.length - macLength - paddingLength;
            RecordCipher.PlaintextParser plaintextParser = new RecordCipher.PlaintextParser(this, plainData);
            byte[] cleanProtocolBytes = plaintextParser.parseByteArrayField(cleanProtocolBytesLength);
            if (this.getState().getVersion().isDTLS() && record.getContentMessageType() == ProtocolMessageType.TLS12_CID) {
                this.parseEncapsulatedRecordBytes(cleanProtocolBytes, record);
            } else {
                record.setCleanProtocolMessageBytes(cleanProtocolBytes);
            }
            if (!this.getState().isEncryptThenMac().booleanValue()) {
                hmac = plaintextParser.parseByteArrayField(macLength);
            }
            computations.setMac(hmac);
            if (this.getState().isEncryptThenMac().booleanValue()) {
                if (this.useExplicitIv) {
                    computations.setAuthenticatedNonMetaData(DataConverter.concatenate((byte[][])new byte[][]{(byte[])record.getComputations().getCbcInitialisationVector().getValue(), (byte[])record.getComputations().getCiphertext().getValue()}));
                } else {
                    computations.setAuthenticatedNonMetaData((byte[])record.getComputations().getCiphertext().getValue());
                }
            } else {
                computations.setAuthenticatedNonMetaData(cleanProtocolBytes);
            }
            computations.setAuthenticatedMetaData(this.collectAdditionalAuthenticatedData(record, this.getState().getVersion()));
            byte[] calculatedHMAC = this.calculateMac(DataConverter.concatenate((byte[][])new byte[][]{(byte[])computations.getAuthenticatedMetaData().getValue(), (byte[])computations.getAuthenticatedNonMetaData().getValue()}), this.getLocalConnectionEndType().getPeer());
            computations.setMacValid(Arrays.equals(calculatedHMAC, (byte[])computations.getMac().getValue()));
        }
        catch (ParserException e) {
            LOGGER.warn("Could not find all components (plaintext, mac, padding) in plaintext record.");
            LOGGER.warn("This is probably us having the wrong keys. Depending on the application this may be fine.");
            LOGGER.warn("Setting clean bytes to protocol message bytes.");
            record.setCleanProtocolMessageBytes(record.getProtocolMessageBytes());
            computations.setMacValid(false);
            computations.setPaddingValid(false);
        }
    }

    private boolean isPaddingValid(byte[] padding) {
        if (padding.length == 0) {
            LOGGER.debug("Zero Byte Padding is invalid");
            return false;
        }
        if (this.getState().getVersion().isSSL()) {
            return padding.length == padding[padding.length - 1] + 1;
        }
        for (int i = 0; i < padding.length; ++i) {
            if (DataConverter.byteToUnsignedInt((byte)padding[i]) == padding.length - 1) continue;
            LOGGER.debug("Padding is invalid");
            return false;
        }
        LOGGER.debug("Padding is valid");
        return true;
    }
}

