/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.cipher;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.cipher.CipherState;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordNullCipher
extends RecordCipher {
    private static final Logger LOGGER = LogManager.getLogger();

    public RecordNullCipher(TlsContext tlsContext, CipherState state) {
        super(tlsContext, state);
    }

    @Override
    public void encrypt(Record record) throws CryptoException {
        LOGGER.debug("Encrypting Record: (null cipher)");
        record.prepareComputations();
        byte[] cleanBytes = (byte[])record.getCleanProtocolMessageBytes().getValue();
        record.setProtocolMessageBytes(cleanBytes);
    }

    @Override
    public void decrypt(Record record) throws CryptoException {
        LOGGER.debug("Decrypting Record: (null cipher)");
        record.prepareComputations();
        byte[] protocolMessageBytes = (byte[])record.getProtocolMessageBytes().getValue();
        record.setCleanProtocolMessageBytes(protocolMessageBytes);
    }
}

