/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.cipher.cryptohelper;

import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CipherType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import java.io.ByteArrayInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyBlockParser
extends Parser<KeySet> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int SEQUENCE_NUMBER_LENGTH = 8;
    public static final int AEAD_IV_LENGTH = 12;
    private final CipherSuite suite;
    private final ProtocolVersion version;

    public KeyBlockParser(byte[] keyBlock, CipherSuite suite, ProtocolVersion version) {
        super(new ByteArrayInputStream(keyBlock));
        this.suite = suite;
        this.version = version;
    }

    @Override
    public void parse(KeySet keys) {
        if (this.suite.getCipherType() != CipherType.AEAD) {
            this.parseClientWriteMacSecret(keys);
            this.parseServerWriteMacSecret(keys);
        }
        this.parseClientWriteKey(keys);
        this.parseServerWriteKey(keys);
        if (this.suite.getCipherType() == CipherType.BLOCK && !this.version.usesExplicitIv() || this.suite.isStreamCipherWithIV()) {
            this.parseClientWriteIvBlock(keys);
            this.parseServerWriteIvBlock(keys);
        } else if (this.suite.getCipherType() == CipherType.AEAD) {
            this.parseClientWriteIvAead(keys);
            this.parseServerWriteIvAead(keys);
        }
    }

    private int getAeadSaltSize() {
        return 12 - this.suite.getCipherAlgorithm().getNonceBytesFromRecord();
    }

    private void parseClientWriteIvBlock(KeySet keys) {
        keys.setClientWriteIv(this.parseByteArrayField(this.getIVSize()));
        LOGGER.debug("ClientWriteIV: {}", (Object)keys.getClientWriteIv());
    }

    private void parseServerWriteIvBlock(KeySet keys) {
        keys.setServerWriteIv(this.parseByteArrayField(this.getIVSize()));
        LOGGER.debug("ServerWriteIV: {}", (Object)keys.getServerWriteIv());
    }

    private void parseClientWriteIvAead(KeySet keys) {
        keys.setClientWriteIv(this.parseByteArrayField(this.getAeadSaltSize()));
        LOGGER.debug("ClientWriteIV AEAD: {}", (Object)keys.getClientWriteIv());
    }

    private void parseServerWriteIvAead(KeySet keys) {
        keys.setServerWriteIv(this.parseByteArrayField(this.getAeadSaltSize()));
        LOGGER.debug("ServerWriteIV AEAD: {}", (Object)keys.getServerWriteIv());
    }

    private void parseClientWriteKey(KeySet keys) {
        keys.setClientWriteKey(this.parseByteArrayField(this.getKeySize()));
        LOGGER.debug("ClientWriteKey: {}", (Object)keys.getClientWriteKey());
    }

    private void parseServerWriteKey(KeySet keys) {
        keys.setServerWriteKey(this.parseByteArrayField(this.getKeySize()));
        LOGGER.debug("ServerWriteKey: {}", (Object)keys.getServerWriteKey());
    }

    private void parseClientWriteMacSecret(KeySet keys) {
        keys.setClientWriteMacSecret(this.parseByteArrayField(this.getMacKeySize()));
        LOGGER.debug("ClientMacKey: {}", (Object)keys.getClientWriteMacSecret());
    }

    private void parseServerWriteMacSecret(KeySet keys) {
        keys.setServerWriteMacSecret(this.parseByteArrayField(this.getMacKeySize()));
        LOGGER.debug("ServerMacKey: {}", (Object)keys.getServerWriteMacSecret());
    }

    private int getMacKeySize() {
        return AlgorithmResolver.getMacAlgorithm(this.version, this.suite).getKeySize();
    }

    private int getKeySize() {
        return this.suite.getCipherAlgorithm().getKeySize();
    }

    private int getIVSize() {
        return this.suite.getCipherAlgorithm().getNonceBytesFromHandshake();
    }
}

