/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.compressor;

import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.compressor.AlgorithmFactory;
import de.rub.nds.tlsattacker.core.record.compressor.Compressor;
import de.rub.nds.tlsattacker.core.record.compressor.compression.CompressionAlgorithm;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordCompressor
extends Compressor<Record> {
    private CompressionAlgorithm algorithm;
    private final ProtocolVersion version;
    private static final Logger LOGGER = LogManager.getLogger();

    public RecordCompressor(TlsContext tlsContext) {
        this.version = tlsContext.getChooser().getSelectedProtocolVersion();
        if (this.version.is13()) {
            this.setMethod(CompressionMethod.NULL);
        } else {
            this.setMethod(tlsContext.getChooser().getSelectedCompressionMethod());
        }
    }

    @Override
    public void compress(Record record) {
        byte[] cleanBytes = (byte[])record.getCleanProtocolMessageBytes().getValue();
        byte[] compressedBytes = this.algorithm.compress(cleanBytes);
        record.setCleanProtocolMessageBytes(compressedBytes);
    }

    public void setMethod(CompressionMethod method) {
        LOGGER.debug("Changing Compression method to {}", (Object)method);
        AlgorithmFactory factory = new AlgorithmFactory();
        this.algorithm = factory.getAlgorithm(this.version, method);
    }
}

