/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.crypto;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordNullCipher;
import de.rub.nds.tlsattacker.core.record.crypto.Decryptor;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordDecryptor
extends Decryptor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TlsContext tlsContext;

    public RecordDecryptor(RecordCipher recordCipher, TlsContext tlsContext) {
        super(recordCipher);
        this.tlsContext = tlsContext;
    }

    @Override
    public void decrypt(Record record) throws ParserException {
        block13: {
            RecordCipher recordCipher;
            LOGGER.debug("Decrypting Record");
            if (this.tlsContext.getChooser().getSelectedProtocolVersion().isDTLS() && record.getEpoch() != null && record.getEpoch().getValue() != null) {
                if (this.tlsContext.getChooser().getSelectedProtocolVersion().isDTLS13() && this.tlsContext.getReadEpoch() > 3 && record.getUnifiedHeader() != null) {
                    recordCipher = this.getRecordCipherForEpochBits((Integer)record.getEpoch().getValue(), record);
                    if (recordCipher == null) {
                        LOGGER.warn("Got no RecordCipher for epoch bits: {}. Using most recent cipher instead.", record.getEpoch().getValue());
                        recordCipher = this.getRecordMostRecentCipher();
                    }
                } else {
                    recordCipher = this.getRecordCipher((Integer)record.getEpoch().getValue());
                }
                if (record.getEncryptedSequenceNumber() != null) {
                    recordCipher.decryptDtls13SequenceNumber(record);
                }
            } else {
                recordCipher = this.getRecordMostRecentCipher();
            }
            record.prepareComputations();
            ProtocolVersion version = ProtocolVersion.getProtocolVersion((byte[])record.getProtocolVersion().getValue());
            if (version == null || !version.isDTLS()) {
                record.setSequenceNumber(BigInteger.valueOf(recordCipher.getState().getReadSequenceNumber()));
            }
            try {
                if (!this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13() || record.getContentMessageType() != ProtocolMessageType.CHANGE_CIPHER_SPEC) {
                    block12: {
                        try {
                            recordCipher.decrypt(record);
                        }
                        catch (CryptoException | ParserException ex) {
                            if (this.recordCipherList.indexOf(recordCipher) <= 0) break block12;
                            LOGGER.warn("Failed to decrypt record, will try to process with previous cipher");
                            ((RecordCipher)this.recordCipherList.get(this.recordCipherList.indexOf(recordCipher) - 1)).decrypt(record);
                        }
                    }
                    recordCipher.getState().increaseReadSequenceNumber();
                    break block13;
                }
                LOGGER.debug("Skipping decryption for legacy CCS");
                new RecordNullCipher(this.tlsContext, recordCipher.getState()).decrypt(record);
            }
            catch (CryptoException ex) {
                throw new ParserException((Throwable)ex);
            }
        }
    }
}

