/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.crypto;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.record.cipher.RecordNullCipher;
import de.rub.nds.tlsattacker.core.record.crypto.Encryptor;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordEncryptor
extends Encryptor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TlsContext tlsContext;
    private final RecordNullCipher nullCipher;

    public RecordEncryptor(RecordCipher recordCipher, TlsContext tlsContext) {
        super(recordCipher);
        this.tlsContext = tlsContext;
        this.nullCipher = RecordCipherFactory.getNullCipher(tlsContext);
    }

    @Override
    public void encrypt(Record record) {
        LOGGER.debug("Encrypting Record:");
        RecordCipher recordCipher = this.tlsContext.getChooser().getSelectedProtocolVersion().isDTLS() ? this.getRecordCipher((Integer)record.getEpoch().getValue()) : this.getRecordMostRecentCipher();
        try {
            record.setSequenceNumber(BigInteger.valueOf(recordCipher.getState().getWriteSequenceNumber()));
            recordCipher.encrypt(record);
        }
        catch (CryptoException ex) {
            LOGGER.warn("Could not encrypt BlobRecord. Using NullCipher", (Throwable)ex);
            try {
                this.nullCipher.encrypt(record);
            }
            catch (CryptoException ex1) {
                LOGGER.error("Could not encrypt with NullCipher", (Throwable)ex1);
            }
        }
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().isDTLS13()) {
            recordCipher.encryptDtls13SequenceNumber(record);
        }
        recordCipher.getState().increaseWriteSequenceNumber();
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().is13()) {
            record.getComputations().setUsedTls13KeySetType(this.tlsContext.getActiveKeySetTypeWrite());
        }
    }
}

