/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.preparator;

import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import de.rub.nds.tlsattacker.core.layer.impl.RecordLayer;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.cipher.RecordNullCipher;
import de.rub.nds.tlsattacker.core.record.compressor.RecordCompressor;
import de.rub.nds.tlsattacker.core.record.crypto.Encryptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordPreparator
extends Preparator<Record> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Record record;
    private final Encryptor encryptor;
    private final TlsContext tlsContext;
    private final RecordCompressor compressor;
    private ProtocolMessageType type;

    public RecordPreparator(TlsContext tlsContext, Record record, Encryptor encryptor, ProtocolMessageType type, RecordCompressor compressor) {
        super(tlsContext.getChooser(), record);
        this.record = record;
        this.encryptor = encryptor;
        this.tlsContext = tlsContext;
        this.compressor = compressor;
        this.type = type;
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing Record");
        this.prepareConnectionId(this.record);
        this.record.prepareComputations();
        this.prepareContentType(this.record);
        this.prepareProtocolVersion(this.record);
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().isDTLS13() && !(this.encryptor.getRecordCipher((Integer)this.record.getEpoch().getValue()) instanceof RecordNullCipher)) {
            this.prepareDtls13UnifiedHeader(this.record);
        }
        this.compressor.compress(this.record);
        this.encrypt();
    }

    public void encrypt() {
        LOGGER.debug("Encrypting Record");
        if (this.chooser.getSelectedProtocolVersion().isTLS13() && this.record.getContentMessageType() == ProtocolMessageType.CHANGE_CIPHER_SPEC && !this.chooser.getConfig().isEncryptChangeCipherSpec().booleanValue()) {
            this.record.prepareComputations();
            this.record.setProtocolMessageBytes((byte[])this.record.getCleanProtocolMessageBytes().getValue());
        } else {
            this.encryptor.encrypt(this.record);
        }
        this.prepareLength(this.record);
    }

    private void prepareConnectionId(Record record) {
        RecordLayer recordLayer;
        byte[] connectionId;
        if (this.chooser.getSelectedProtocolVersion().isDTLS() && (connectionId = (recordLayer = this.tlsContext.getRecordLayer()).getEncryptor().getRecordCipher(recordLayer.getWriteEpoch()).getState().getConnectionId()) != null && this.tlsContext.isExtensionNegotiated(ExtensionType.CONNECTION_ID)) {
            record.setConnectionId(connectionId);
            LOGGER.debug("ConnectionId: {}", record.getConnectionId().getValue());
        }
    }

    private void prepareContentType(Record record) {
        record.setContentType(this.type.getValue());
        LOGGER.debug("ContentType: {}", (Object)this.type.getValue());
        this.prepareContentMessageType(this.type);
    }

    private void prepareProtocolVersion(Record record) {
        if (this.chooser.getSelectedProtocolVersion().isTLS13() || this.tlsContext.getActiveKeySetTypeWrite() == Tls13KeySetType.EARLY_TRAFFIC_SECRETS) {
            record.setProtocolVersion(ProtocolVersion.TLS12.getValue());
        } else if (this.chooser.getSelectedProtocolVersion().isDTLS13()) {
            record.setProtocolVersion(ProtocolVersion.DTLS12.getValue());
        } else {
            record.setProtocolVersion(this.chooser.getSelectedProtocolVersion().getValue());
        }
        LOGGER.debug("ProtocolVersion: {}", record.getProtocolVersion().getValue());
    }

    private void prepareLength(Record record) {
        record.setLength(((byte[])record.getProtocolMessageBytes().getValue()).length);
        LOGGER.debug("Length: {}", record.getLength().getValue());
    }

    protected void prepareContentMessageType(ProtocolMessageType type) {
        ((Record)this.getObject()).setContentMessageType(this.type);
        LOGGER.debug("ContentMessageType: {}", (Object)type.getArrayValue());
    }

    protected void prepareDtls13UnifiedHeader(Record record) {
        record.setUnifiedHeader(this.createDtls13UnifiedHeader(record, this.tlsContext));
        LOGGER.debug("UnifiedHeader: 00{}", (Object)Integer.toBinaryString(((Byte)record.getUnifiedHeader().getValue()).byteValue()));
    }

    private byte createDtls13UnifiedHeader(Record record, TlsContext context) {
        byte header = 32;
        if (record.getConnectionId() != null && record.getConnectionId().getValue() != null && ((byte[])record.getConnectionId().getValue()).length > 0) {
            header = (byte)(header ^ 0x10);
        }
        if (context.getConfig().getUseDtls13HeaderSeqNumSizeLongEncoding().booleanValue()) {
            header = (byte)(header ^ 8);
        }
        header = (byte)(header ^ 4);
        byte lowerEpoch = (byte)((Integer)record.getEpoch().getValue() % 4);
        header = (byte)(header ^ lowerEpoch);
        return header;
    }
}

