/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.socket;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.AlertDescription;
import de.rub.nds.tlsattacker.core.constants.AlertLevel;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.AlertMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ApplicationMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TlsAttackerSocket {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_SEND_BUFFER_SIZE = 16384;
    private final State state;

    public TlsAttackerSocket(State state) {
        this.state = state;
    }

    public void sendRawBytes(byte[] bytes) throws IOException {
        this.state.getContext().getTransportHandler().sendData(bytes);
    }

    public byte[] receiveRawBytes() throws IOException {
        return this.state.getContext().getTransportHandler().fetchData();
    }

    public void send(String string) {
        this.send(string.getBytes(Charset.defaultCharset()));
    }

    public void send(byte[] bytes) {
        int actuallyRead;
        ApplicationMessage message = new ApplicationMessage();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        byte[] sendingBytes = new byte[16384];
        do {
            actuallyRead = 0;
            try {
                actuallyRead = stream.read(sendingBytes);
                if (actuallyRead <= 0) continue;
                message.setDataConfig(Arrays.copyOf(sendingBytes, actuallyRead));
                this.send(message);
            }
            catch (IOException ex) {
                LOGGER.warn((Object)ex);
            }
        } while (actuallyRead > 0);
    }

    public void send(ProtocolMessage message) {
        SendAction action = new SendAction(this.state.getContext().getConnection().getAlias(), message);
        action.execute(this.state);
    }

    public byte[] receiveBytes() throws IOException {
        ReceiveAction action = new ReceiveAction(this.state.getContext().getConnection().getAlias(), new ApplicationMessage());
        action.execute(this.state);
        List<ProtocolMessage> receivedMessages = action.getReceivedMessages();
        LinkedList<ApplicationMessage> receivedAppMessages = new LinkedList<ApplicationMessage>();
        for (ProtocolMessage message : receivedMessages) {
            if (!(message instanceof ApplicationMessage)) continue;
            receivedAppMessages.add((ApplicationMessage)message);
        }
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        for (ApplicationMessage message : receivedAppMessages) {
            stream.write((byte[])message.getData().getValue());
        }
        return stream.toByteArray();
    }

    public String receiveString() throws IOException {
        return new String(this.receiveBytes(), Charset.defaultCharset());
    }

    public void close() throws IOException {
        AlertMessage closeNotify = new AlertMessage();
        closeNotify.setConfig(AlertLevel.WARNING, AlertDescription.CLOSE_NOTIFY);
        this.send(closeNotify);
        this.state.getContext().getTransportHandler().closeConnection();
    }
}

