/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.state;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.layer.LayerStack;
import de.rub.nds.tlsattacker.core.layer.LayerStackFactory;
import de.rub.nds.tlsattacker.core.layer.context.HttpContext;
import de.rub.nds.tlsattacker.core.layer.context.TcpContext;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.state.ContextContainer;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceNormalizer;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.tlsattacker.core.workflow.filter.Filter;
import de.rub.nds.tlsattacker.core.workflow.filter.FilterFactory;
import de.rub.nds.tlsattacker.core.workflow.filter.FilterType;
import de.rub.nds.tlsattacker.transport.tcp.ServerTcpTransportHandler;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class State {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ContextContainer contextContainer = new ContextContainer();
    private Config config = null;
    private RunningModeType runningMode = null;
    @HoldsModifiableVariable
    private final WorkflowTrace workflowTrace;
    private WorkflowTrace originalWorkflowTrace;
    private long startTimestamp;
    private long endTimestamp;
    private Throwable executionException;
    private LinkedList<Process> spawnedSubprocesses;

    public State() {
        this(new Config());
    }

    public State(WorkflowTrace trace) {
        this(new Config(), trace);
    }

    public State(Config config) {
        this.config = config;
        this.runningMode = config.getDefaultRunningMode();
        this.spawnedSubprocesses = new LinkedList();
        this.workflowTrace = this.loadWorkflowTrace();
        this.initState();
    }

    public State(Config config, WorkflowTrace workflowTrace) {
        this.config = config;
        this.runningMode = config.getDefaultRunningMode();
        this.spawnedSubprocesses = new LinkedList();
        this.workflowTrace = workflowTrace;
        this.initState();
    }

    public void reset() {
        List<Context> previousContexts = this.contextContainer.getAllContexts();
        this.contextContainer.clear();
        this.workflowTrace.reset();
        this.killAllSpawnedSubprocesses();
        this.initState();
        this.retainServerTcpTransportHandlers(previousContexts);
    }

    private void retainServerTcpTransportHandlers(List<Context> previousContexts) {
        previousContexts.forEach(oldContext -> {
            if (oldContext.getTransportHandler() instanceof ServerTcpTransportHandler) {
                for (Context context : this.contextContainer.getAllContexts()) {
                    if (!context.getConnection().getAlias().equals(oldContext.getConnection().getAlias())) continue;
                    context.setTransportHandler(oldContext.getTransportHandler());
                }
            }
        });
    }

    public final void initState() {
        if (this.config.isFiltersKeepUserSettings().booleanValue()) {
            this.originalWorkflowTrace = WorkflowTrace.copy(this.workflowTrace);
        }
        WorkflowTraceNormalizer normalizer = new WorkflowTraceNormalizer();
        normalizer.normalize(this.workflowTrace, this.config, this.runningMode);
        this.workflowTrace.setDirty(false);
        for (AliasedConnection con : this.workflowTrace.getConnections()) {
            Context ctx = new Context(this, con);
            LayerStack layerStack = LayerStackFactory.createLayerStack(this.config.getDefaultLayerConfiguration(), ctx);
            ctx.setLayerStack(layerStack);
            this.addContext(ctx);
        }
    }

    private WorkflowTrace loadWorkflowTrace() {
        if (this.config.getWorkflowTraceType() == null) {
            throw new ConfigurationException("Could not load workflow trace, type is null");
        }
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace trace = factory.createWorkflowTrace(this.config.getWorkflowTraceType(), this.runningMode);
        LOGGER.debug("Created new {} workflow trace", (Object)this.config.getWorkflowTraceType());
        LOGGER.debug("Workflow trace: {}", (Object)trace);
        return trace;
    }

    public Config getConfig() {
        return this.config;
    }

    public WorkflowTrace getWorkflowTrace() {
        return this.workflowTrace;
    }

    public WorkflowTrace getOriginalWorkflowTrace() {
        return this.originalWorkflowTrace;
    }

    public void replaceContext(Context newContext) {
        this.contextContainer.replaceContext(newContext);
    }

    public Context getContext() {
        return this.contextContainer.getContext();
    }

    public Context getContext(String alias) {
        return this.contextContainer.getContext(alias);
    }

    public TlsContext getTlsContext(String alias) {
        return this.getContext(alias).getTlsContext();
    }

    public TlsContext getTlsContext() {
        return this.getContext().getTlsContext();
    }

    public HttpContext getHttpContext(String alias) {
        return this.getContext(alias).getHttpContext();
    }

    public HttpContext getHttpContext() {
        return this.getContext().getHttpContext();
    }

    public TcpContext getTcpContext(String alias) {
        return this.getContext(alias).getTcpContext();
    }

    public TcpContext getTcpContext() {
        return this.getContext().getTcpContext();
    }

    public List<Context> getAllContexts() {
        return this.contextContainer.getAllContexts();
    }

    public List<Context> getInboundContexts() {
        return this.contextContainer.getInboundContexts();
    }

    public List<Context> getOutboundContexts() {
        return this.contextContainer.getOutboundContexts();
    }

    public RunningModeType getRunningMode() {
        return this.runningMode;
    }

    public void setRunningMode(RunningModeType runningMode) {
        this.runningMode = runningMode;
    }

    private void addContext(Context context) {
        this.contextContainer.addContext(context);
    }

    public WorkflowTrace getWorkflowTraceCopy() {
        return WorkflowTrace.copy(this.workflowTrace);
    }

    public WorkflowTrace getFilteredTraceCopy() {
        return this.getFilteredTraceCopy(this.workflowTrace);
    }

    private WorkflowTrace getFilteredTraceCopy(WorkflowTrace trace) {
        WorkflowTrace filtered = WorkflowTrace.copy(trace);
        this.filterTrace(filtered);
        return filtered;
    }

    private void filterTrace(WorkflowTrace trace) {
        List<FilterType> filters = this.config.getOutputFilters();
        if (filters == null || filters.isEmpty()) {
            LOGGER.debug("No filters to apply, output filter list is empty");
            return;
        }
        if (filters.contains(null)) {
            LOGGER.debug("No filters to apply");
            return;
        }
        for (FilterType filterType : this.config.getOutputFilters()) {
            Filter filter = FilterFactory.createWorkflowTraceFilter(filterType, this.config);
            filter.applyFilter(trace);
            if (!this.config.isFiltersKeepUserSettings().booleanValue()) continue;
            filter.postFilter(trace, this.originalWorkflowTrace);
        }
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public void setEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public Throwable getExecutionException() {
        return this.executionException;
    }

    public void setExecutionException(Throwable executionException) {
        this.executionException = executionException;
    }

    public void addSpawnedSubprocess(Process process) {
        if (process != null) {
            this.spawnedSubprocesses.add(process);
        }
    }

    public void killAllSpawnedSubprocesses() {
        for (Process process : this.spawnedSubprocesses) {
            process.destroy();
        }
        this.spawnedSubprocesses.clear();
    }
}

