/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.state.parser;

import de.rub.nds.protocol.constants.MacAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.state.SessionTicket;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class SessionTicketParser
extends Parser<SessionTicket> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final byte[] configTicketKeyName;
    private final CipherAlgorithm configCipherAlgorithm;
    private final MacAlgorithm configMacAlgorithm;
    private final SessionTicket sessionTicket;

    public SessionTicketParser(int startposition, byte[] array, SessionTicket sessionTicket, byte[] configTicketKeyName, CipherAlgorithm configCipherAlgorithm, MacAlgorithm configMacAlgorithm) {
        super(new ByteArrayInputStream(array, startposition, array.length - startposition));
        this.configTicketKeyName = configTicketKeyName;
        this.configCipherAlgorithm = configCipherAlgorithm;
        this.configMacAlgorithm = configMacAlgorithm;
        this.sessionTicket = sessionTicket;
    }

    private void parseKeyName(SessionTicket sessionTicket) {
        sessionTicket.setKeyName(this.parseByteArrayField(this.configTicketKeyName.length));
        LOGGER.debug("Parsed session ticket key name {} ", sessionTicket.getKeyName().getValue());
        if (!Arrays.equals((byte[])sessionTicket.getKeyName().getValue(), this.configTicketKeyName)) {
            LOGGER.warn("Parsed session ticket key name does not match expected key name - subsequent parsing will probably fail");
        }
    }

    private void parseIV(SessionTicket sessionTicket) {
        sessionTicket.setIV(this.parseByteArrayField(this.configCipherAlgorithm.getBlocksize()));
        LOGGER.debug("Parsed session ticket IV {}", new Supplier[]{() -> sessionTicket.getIV().getValue()});
    }

    private void parseEncryptedStateLength(SessionTicket sessionTicket) {
        sessionTicket.setEncryptedStateLength(this.parseIntField(2));
        LOGGER.debug("Parsed encrypted state length {}", new Supplier[]{() -> sessionTicket.getEncryptedStateLength().getValue()});
    }

    private void parseEncryptedState(SessionTicket sessionTicket) {
        sessionTicket.setEncryptedState(this.parseByteArrayField((Integer)sessionTicket.getEncryptedStateLength().getValue()));
        LOGGER.debug("Parsed session ticket encrypted state {}", new Supplier[]{() -> sessionTicket.getEncryptedState().getValue()});
    }

    private void parseMAC(SessionTicket sessionTicket) {
        sessionTicket.setMAC(this.parseByteArrayField(this.configMacAlgorithm.getMacLength()));
        LOGGER.debug("Parsed session ticket MAC {}", new Supplier[]{() -> sessionTicket.getMAC().getValue()});
    }

    @Override
    public void parse(SessionTicket sessionTicket) {
        this.parseKeyName(sessionTicket);
        this.parseIV(sessionTicket);
        this.parseEncryptedStateLength(sessionTicket);
        this.parseEncryptedState(sessionTicket);
        this.parseMAC(sessionTicket);
    }
}

