/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.state.parser;

import de.rub.nds.tlsattacker.core.constants.ClientAuthenticationType;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.state.StatePlaintext;
import java.io.ByteArrayInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatePlaintextParser
extends Parser<StatePlaintext> {
    private static final Logger LOGGER = LogManager.getLogger();

    public StatePlaintextParser(int startposition, byte[] array) {
        super(new ByteArrayInputStream(array, startposition, array.length - startposition));
    }

    @Override
    public void parse(StatePlaintext statePlaintext) {
        this.parseProtocolVersion(statePlaintext);
        this.parseCipherSuite(statePlaintext);
        this.parseCompressionMethod(statePlaintext);
        this.parseMasterSecret(statePlaintext);
        this.parseClientAuthenticationType(statePlaintext);
        if (((Byte)statePlaintext.getClientAuthenticationType().getValue()).byteValue() != ClientAuthenticationType.ANONYMOUS.getValue()) {
            throw new UnsupportedOperationException("Parsing for client authentication data is not implemented yet");
        }
        this.parseTimestamp(statePlaintext);
    }

    private void parseProtocolVersion(StatePlaintext statePlaintext) {
        statePlaintext.setProtocolVersion(this.parseByteArrayField(2));
        LOGGER.debug("Parsed protocol version from state {}", statePlaintext.getProtocolVersion().getValue());
    }

    private void parseCipherSuite(StatePlaintext statePlaintext) {
        statePlaintext.setCipherSuite(this.parseByteArrayField(2));
        LOGGER.debug("Parsed cipher suite from state {}", statePlaintext.getCipherSuite().getValue());
    }

    private void parseCompressionMethod(StatePlaintext statePlaintext) {
        statePlaintext.setCompressionMethod(this.parseByteField(1));
        LOGGER.debug("Parsed compression method from state {}", statePlaintext.getCompressionMethod().getValue());
    }

    private void parseMasterSecret(StatePlaintext statePlaintext) {
        statePlaintext.setMasterSecret(this.parseByteArrayField(48));
        LOGGER.debug("Parsed master secret from state {}", statePlaintext.getMasterSecret().getValue());
    }

    private void parseClientAuthenticationType(StatePlaintext statePlaintext) {
        statePlaintext.setClientAuthenticationType(this.parseByteField(1));
        LOGGER.debug("Parsed client authentication type from state {}", statePlaintext.getClientAuthenticationType().getValue());
    }

    private void parseTimestamp(StatePlaintext statePlaintext) {
        statePlaintext.setTimestamp(this.parseIntField(4));
        LOGGER.debug("Parsed time stamp from state {}", (Object)statePlaintext.getTimestamp());
    }
}

