/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.tcp;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.tcp.TcpStreamContainerHandler;
import de.rub.nds.tlsattacker.core.tcp.TcpStreamContainerParser;
import de.rub.nds.tlsattacker.core.tcp.TcpStreamContainerPreparator;
import de.rub.nds.tlsattacker.core.tcp.TcpStreamContainerSerializer;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TcpStreamContainer
implements DataContainer {
    private transient byte[] configData;
    private ModifiableByteArray data;

    public TcpStreamContainer() {
    }

    public TcpStreamContainer(byte[] configData) {
        this.configData = configData;
    }

    public ModifiableByteArray getData() {
        return this.data;
    }

    public void setData(ModifiableByteArray data) {
        this.data = data;
    }

    public void setData(byte[] data) {
        this.data = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.data, (byte[])data);
    }

    public TcpStreamContainerParser getParser(Context context, InputStream stream) {
        return new TcpStreamContainerParser(stream);
    }

    public TcpStreamContainerPreparator getPreparator(Context context) {
        return new TcpStreamContainerPreparator(context.getChooser(), this);
    }

    public TcpStreamContainerSerializer getSerializer(Context context) {
        return new TcpStreamContainerSerializer(this);
    }

    public TcpStreamContainerHandler getHandler(Context context) {
        return new TcpStreamContainerHandler();
    }

    public byte[] getConfigData() {
        return this.configData;
    }

    public void setConfigData(byte[] configData) {
        this.configData = configData;
    }

    public String toString() {
        return "TCP{" + ((byte[])this.data.getValue()).length + " Bytes}";
    }
}

