/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.tokenbinding;

import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageParser;
import de.rub.nds.tlsattacker.core.tokenbinding.TokenBindingMessage;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TokenBindingMessageParser
extends ProtocolMessageParser<TokenBindingMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public TokenBindingMessageParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(TokenBindingMessage message) {
        message.setTokenbindingsLength(this.parseIntField(2));
        LOGGER.debug("TokenbindingLength: {}", message.getTokenbindingsLength().getValue());
        message.setTokenbindingType(this.parseByteField(1));
        LOGGER.debug("TokenBindingType: {}", message.getTokenbindingType().getValue());
        message.setKeyParameter(this.parseByteField(1));
        LOGGER.debug("KeyParameter: {}", message.getKeyParameter().getValue());
        TokenBindingKeyParameters keyParameter = TokenBindingKeyParameters.getTokenBindingKeyParameter((Byte)message.getKeyParameter().getValue());
        message.setKeyLength(this.parseIntField(2));
        LOGGER.debug("KeyLength: {}", message.getKeyLength().getValue());
        if (keyParameter.equals((Object)TokenBindingKeyParameters.ECDSAP256)) {
            message.setPointLength(this.parseIntField(1));
            LOGGER.debug("PointLength: {}", message.getPointLength().getValue());
            message.setPoint(this.parseByteArrayField((Integer)message.getPointLength().getValue()));
            LOGGER.debug("Point: {}", message.getPoint().getValue());
        } else {
            message.setModulusLength(this.parseIntField(2));
            message.setModulus(this.parseByteArrayField((Integer)message.getModulusLength().getValue()));
            message.setPublicExponentLength(this.parseIntField(1));
            message.setPublicExponent(this.parseByteArrayField((Integer)message.getPublicExponentLength().getValue()));
        }
        message.setSignatureLength(this.parseIntField(2));
        LOGGER.debug("SignatureLength: {}", message.getSignatureLength().getValue());
        message.setSignature(this.parseByteArrayField((Integer)message.getSignatureLength().getValue()));
        LOGGER.debug("Signature: {}", message.getSignature().getValue());
        message.setExtensionLength(this.parseIntField(2));
        LOGGER.debug("ExtensionLength: {}", message.getExtensionLength().getValue());
        message.setExtensionBytes(this.parseByteArrayField((Integer)message.getExtensionLength().getValue()));
        LOGGER.debug("Extensions: {}", message.getExtensionBytes().getValue());
    }
}

