/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.tokenbinding;

import de.rub.nds.protocol.constants.HashAlgorithm;
import de.rub.nds.protocol.constants.NamedEllipticCurveParameters;
import de.rub.nds.protocol.constants.SignatureAlgorithm;
import de.rub.nds.protocol.crypto.ec.EllipticCurveSECP256R1;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.PointFormatter;
import de.rub.nds.protocol.crypto.key.EcdsaPrivateKey;
import de.rub.nds.protocol.crypto.signature.EcdsaSignatureComputations;
import de.rub.nds.protocol.crypto.signature.SignatureCalculator;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.protocol.exception.PreparationException;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessagePreparator;
import de.rub.nds.tlsattacker.core.tokenbinding.TokenBindingMessage;
import de.rub.nds.tlsattacker.core.tokenbinding.TokenBindingMessageSerializer;
import de.rub.nds.tlsattacker.core.tokenbinding.TokenCalculator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TokenBindingMessagePreparator
extends ProtocolMessagePreparator<TokenBindingMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TokenBindingMessage message;

    public TokenBindingMessagePreparator(Chooser chooser, TokenBindingMessage message) {
        super(chooser, message);
        this.message = message;
    }

    @Override
    protected void prepareProtocolMessageContents() {
        this.message.setTokenbindingType(this.chooser.getConfig().getDefaultTokenBindingType().getTokenBindingTypeValue());
        if (this.chooser.getConfig().getDefaultTokenBindingKeyParameters().size() > 0) {
            this.message.setKeyParameter(this.chooser.getConfig().getDefaultTokenBindingKeyParameters().get(0).getValue());
            if (this.chooser.getConfig().getDefaultTokenBindingKeyParameters().get(0) == TokenBindingKeyParameters.ECDSAP256) {
                EllipticCurveSECP256R1 curve = new EllipticCurveSECP256R1();
                BigInteger privateKey = this.chooser.getConfig().getDefaultTokenBindingEcPrivateKey();
                LOGGER.debug("Using private Key: {}", (Object)privateKey);
                Point publicKey = curve.mult(privateKey, curve.getBasePoint());
                this.message.setPoint(PointFormatter.toRawFormat((Point)publicKey));
                this.message.setPointLength(((byte[])this.message.getPoint().getValue()).length);
                byte[] signature = this.generateSignature(SignatureAndHashAlgorithm.ECDSA_SHA256, this.generateToBeSigned());
                this.message.setSignature(signature);
            } else {
                this.message.setModulus(this.chooser.getConfig().getDefaultTokenBindingRsaModulus().toByteArray());
                this.message.setModulusLength(((byte[])this.message.getModulus().getValue()).length);
                this.message.setPublicExponent(this.chooser.getConfig().getDefaultTokenBindingRsaPublicKey().toByteArray());
                this.message.setPublicExponentLength(((byte[])this.message.getPublicExponent().getValue()).length);
                this.message.setSignature(new byte[0]);
            }
        } else {
            this.message.setKeyParameter((byte)0);
            this.message.setSignature(new byte[0]);
        }
        TokenBindingMessageSerializer serializer = new TokenBindingMessageSerializer(this.message);
        this.message.setKeyLength(serializer.serializeKey().length);
        this.message.setExtensionBytes(new byte[0]);
        this.message.setExtensionLength(((byte[])this.message.getExtensionBytes().getValue()).length);
        this.message.setSignatureLength(((byte[])this.message.getSignature().getValue()).length);
        serializer = new TokenBindingMessageSerializer(this.message);
        this.message.setTokenbindingsLength(serializer.serializeBinding().length);
    }

    private byte[] generateSignature(SignatureAndHashAlgorithm algorithm, byte[] toBeHashedAndSigned) {
        SignatureCalculator calculator = new SignatureCalculator();
        calculator.computeRawEcdsaSignature((EcdsaSignatureComputations)this.message.getSignatureComputations(SignatureAlgorithm.ECDSA), new EcdsaPrivateKey(this.chooser.getConfig().getDefaultTokenBindingEcPrivateKey(), this.chooser.getConfig().getDefaultEcdsaNonce(), NamedEllipticCurveParameters.SECP256R1), toBeHashedAndSigned, HashAlgorithm.SHA256);
        return (byte[])this.message.getSignatureComputations(algorithm.getSignatureAlgorithm()).getSignatureBytes().getValue();
    }

    private byte[] generateToBeSigned() {
        try {
            SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
            stream.write(new byte[]{(Byte)this.message.getTokenbindingType().getValue()});
            stream.write(new byte[]{(Byte)this.message.getKeyParameter().getValue()});
            stream.write(TokenCalculator.calculateEKM(this.chooser, 32));
            return stream.toByteArray();
        }
        catch (CryptoException ex) {
            throw new PreparationException("Could not generate data to be Signed!", (Throwable)ex);
        }
    }
}

