/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.util;

import de.rub.nds.modifiablevariable.util.BadRandom;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicTlsClient
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CipherSuite cipherSuite;
    private final ProtocolVersion tlsVersion;
    private final String serverHost;
    private final int serverPort;
    private final String serverPrettyName;
    private boolean retryConnect;
    private int retryTimeout = 100;
    private volatile boolean finished = false;

    public BasicTlsClient(String serverHost, int serverPort, ProtocolVersion version, CipherSuite cipherSuite) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        this.cipherSuite = cipherSuite;
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.serverPrettyName = serverHost + ":" + serverPort;
        this.tlsVersion = version;
        this.retryConnect = true;
    }

    public BasicTlsClient() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        this("127.0.0.1", 4433, ProtocolVersion.TLS12, CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA);
    }

    public void setRetryConnect(boolean retryConnect) {
        this.retryConnect = retryConnect;
    }

    @Override
    public void run() {
        Socket socket = null;
        try {
            block16: {
                LOGGER.info("Connecting to {}", (Object)this.serverPrettyName);
                if (this.retryConnect) {
                    while (true) {
                        try {
                            socket = this.getFreshSocket(this.tlsVersion);
                            break block16;
                        }
                        catch (ConnectException x) {
                            LOGGER.info("retry: connect to {}", (Object)this.serverPrettyName);
                            TimeUnit.MILLISECONDS.sleep(this.retryTimeout);
                            continue;
                        }
                        break;
                    }
                }
                socket = this.getFreshSocket(this.tlsVersion);
            }
            ((SSLSocket)socket).getSession().invalidate();
            LOGGER.info("Closing session with {}", (Object)this.serverPrettyName);
            socket.close();
            LOGGER.info("Closed ({})", (Object)this.serverPrettyName);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
        }
        finally {
            try {
                if (socket != null && !socket.isClosed()) {
                    socket.close();
                }
            }
            catch (IOException e) {
                LOGGER.debug((Object)e);
            }
            this.finished = true;
            LOGGER.info("Shutdown complete");
        }
    }

    private SSLSocket getFreshSocket(ProtocolVersion version) throws IOException, Exception {
        SSLContext allowAllContext = this.getAllowAllContext();
        SSLSocketFactory sslFact = allowAllContext.getSocketFactory();
        SSLSocket socket = (SSLSocket)sslFact.createSocket(this.serverHost, this.serverPort);
        socket.setEnabledCipherSuites(new String[]{this.cipherSuite.name()});
        String[] versions = new String[1];
        switch (version) {
            case SSL3: {
                versions[0] = "SSLv3";
                break;
            }
            case TLS10: {
                versions[0] = "TLSv1";
                break;
            }
            case TLS11: {
                versions[0] = "TLSv1.1";
                break;
            }
            case TLS12: {
                versions[0] = "TLSv1.2";
                break;
            }
            default: {
                throw new UnsupportedOperationException("This version is not supported");
            }
        }
        socket.setEnabledProtocols(versions);
        return socket;
    }

    protected SSLContext getAllowAllContext() {
        SSLContext allowAllContext = null;
        try {
            allowAllContext = SSLContext.getInstance("TLS");
            allowAllContext.getClientSessionContext().setSessionCacheSize(1);
            allowAllContext.init(null, new TrustManager[]{new X509TrustManager(this){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }}, (SecureRandom)new BadRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            LOGGER.warn((Object)e);
        }
        return allowAllContext;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

