/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.protocol.exception.SkipActionException;
import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.core.workflow.action.executor.WorkflowExecutorType;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultWorkflowExecutor
extends WorkflowExecutor {
    private static final Logger LOGGER = LogManager.getLogger();

    public DefaultWorkflowExecutor(State state) {
        super(WorkflowExecutorType.DEFAULT, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeWorkflow() throws WorkflowExecutionException {
        if (Boolean.TRUE.equals(this.config.isWorkflowExecutorShouldOpen())) {
            try {
                this.initAllLayer();
            }
            catch (IOException ex) {
                throw new WorkflowExecutionException("Workflow not executed, could not initialize transport handler: ", (Throwable)ex);
            }
        }
        this.state.getWorkflowTrace().reset();
        this.state.setStartTimestamp(System.currentTimeMillis());
        TlsAction lastExecutedAction = null;
        List<TlsAction> tlsActions = this.state.getWorkflowTrace().getTlsActions();
        for (int i = 0; i < tlsActions.size(); ++i) {
            TlsAction action = tlsActions.get(i);
            if (this.config.isStopActionsAfterFatal().booleanValue() && this.isReceivedFatalAlert()) {
                LOGGER.debug("Skipping all Actions, received FatalAlert, StopActionsAfterFatal active");
                break;
            }
            if (this.config.getStopReceivingAfterFatal().booleanValue() && this.isReceivedFatalAlert() && tlsActions instanceof ReceivingAction) {
                LOGGER.debug("Skipping all ReceiveActions, received FatalAlert, StopActionsAfterFatal active");
                break;
            }
            if (this.config.getStopActionsAfterWarning().booleanValue() && this.isReceivedWarningAlert()) {
                LOGGER.debug("Skipping all Actions, received Warning Alert, StopActionsAfterWarning active");
                break;
            }
            if (this.config.getStopActionsAfterIOException().booleanValue() && this.isIoException()) {
                if (lastExecutedAction instanceof SendingAction) {
                    LOGGER.debug("Received IO Exception with StopActionsAfterIOException active, skipping to next receive action to process pending message bytes.");
                    this.processPendingReceiveBufferBytes(i - 1);
                    break;
                }
                LOGGER.debug("Skipping all Actions, received IO Exception, StopActionsAfterIOException active");
                break;
            }
            try {
                this.executeAction(action, this.state);
            }
            catch (SkipActionException ex) {
                continue;
            }
            finally {
                lastExecutedAction = action;
            }
            if (!this.config.isStopTraceAfterUnexpected().booleanValue() || action.executedAsPlanned() || action.getActionOptions() != null && action.getActionOptions().contains((Object)ActionOption.MAY_FAIL)) continue;
            if (lastExecutedAction instanceof SendingAction) {
                LOGGER.debug("SendingAction did not execute as planned, skipping to next receive action to process pending message bytes.");
                this.processPendingReceiveBufferBytes(i);
                break;
            }
            LOGGER.debug("Skipping all Actions, action did not execute as planned.");
            break;
        }
        if (this.config.isFinishWithCloseNotify().booleanValue()) {
            for (Context context : this.state.getAllContexts()) {
                this.sendCloseNotify(context.getTlsContext());
            }
        }
        this.setFinalSocketState();
        if (this.config.isWorkflowExecutorShouldClose().booleanValue()) {
            this.closeConnection();
        }
        if (this.state.getWorkflowTrace().executedAsPlanned()) {
            LOGGER.info("Workflow executed as planned.");
        } else {
            LOGGER.info("Workflow was not executed as planned.");
        }
        if (this.config.isResetWorkflowTracesBeforeSaving().booleanValue()) {
            this.state.getWorkflowTrace().reset();
        }
        try {
            if (this.getAfterExecutionCallback() != null) {
                this.getAfterExecutionCallback().apply(this.state);
            }
        }
        catch (Exception ex) {
            LOGGER.trace("Error during AfterExecutionCallback", (Throwable)ex);
        }
    }

    private void processPendingReceiveBufferBytes(int lastActionExecutedIndex) {
        List<TlsAction> tlsActions = this.state.getWorkflowTrace().getTlsActions();
        ReceivingAction nextReceiveAction = null;
        for (int i = lastActionExecutedIndex + 1; i < tlsActions.size(); ++i) {
            if (!(tlsActions.get(i) instanceof ReceivingAction)) continue;
            nextReceiveAction = (ReceivingAction)((Object)tlsActions.get(i));
            break;
        }
        if (nextReceiveAction != null) {
            try {
                this.executeAction((TlsAction)((Object)nextReceiveAction), this.state);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

