/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.protocol.exception.SkipActionException;
import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.layer.SpecificSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.impl.QuicPacketLayer;
import de.rub.nds.tlsattacker.core.quic.constants.QuicTransportErrorCodes;
import de.rub.nds.tlsattacker.core.quic.frame.ConnectionCloseFrame;
import de.rub.nds.tlsattacker.core.quic.packet.InitialPacket;
import de.rub.nds.tlsattacker.core.quic.packet.OneRTTPacket;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.core.workflow.action.executor.WorkflowExecutorType;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QuicWorkflowExecutor
extends WorkflowExecutor {
    private static final Logger LOGGER = LogManager.getLogger();

    public QuicWorkflowExecutor(State state) {
        super(WorkflowExecutorType.QUIC, state);
    }

    @Override
    public void executeWorkflow() throws WorkflowExecutionException {
        if (Boolean.TRUE.equals(this.config.isWorkflowExecutorShouldOpen())) {
            try {
                this.initAllLayer();
            }
            catch (IOException ex) {
                throw new WorkflowExecutionException("Workflow not executed, could not initialize transport handler: ", (Throwable)ex);
            }
        }
        this.state.setStartTimestamp(System.currentTimeMillis());
        List<TlsAction> tlsActions = this.state.getWorkflowTrace().getTlsActions();
        int retransmissions = 0;
        int retransmissionActionIndex = 0;
        for (int i = 0; i < tlsActions.size(); ++i) {
            if (i != 0 && !(tlsActions.get(i) instanceof ReceivingAction) && tlsActions.get(i - 1) instanceof ReceivingAction) {
                retransmissionActionIndex = i;
            }
            if (this.shouldStopDueToErrorCondition()) break;
            TlsAction action = tlsActions.get(i);
            boolean notAcknowledgeReceiving = false;
            if (action.getActionOptions() != null) {
                notAcknowledgeReceiving = action.getActionOptions().contains((Object)ActionOption.QUIC_DO_NOT_ACK_RECEPTION_OF_PACKET);
            }
            QuicPacketLayer layer = (QuicPacketLayer)this.state.getContext().getLayerStack().getLayer(QuicPacketLayer.class);
            layer.setTemporarilyDisabledAcks(notAcknowledgeReceiving);
            if (!action.isExecuted()) {
                try {
                    this.executeAction(action, this.state);
                }
                catch (SkipActionException ex) {
                    continue;
                }
            }
            if (action instanceof SendingAction) {
                this.executeRetransmission((SendingAction)((Object)action));
            } else if (action instanceof ReceivingAction) {
                action.reset();
                try {
                    this.executeAction(action, this.state);
                }
                catch (SkipActionException ex) {
                    continue;
                }
            }
            layer.setTemporarilyDisabledAcks(false);
            if (action.executedAsPlanned() || action.getActionOptions() != null && action.getActionOptions().contains((Object)ActionOption.MAY_FAIL)) continue;
            if (this.config.isStopTraceAfterUnexpected().booleanValue()) {
                LOGGER.debug("Skipping all Actions, action did not execute as planned.");
                break;
            }
            if (retransmissions == this.config.getMaxUDPRetransmissions()) {
                LOGGER.debug("Hit max retransmissions, stopping workflow");
                break;
            }
            i = retransmissionActionIndex - 1;
            ++retransmissions;
        }
        if (this.config.isFinishWithCloseNotify().booleanValue()) {
            try {
                this.sendConnectionCloseFrame(this.state.getContext().getQuicContext().isApplicationSecretsInitialized());
            }
            catch (IOException ex) {
                LOGGER.warn("Error while sending ConnectionCloseFrame", (Throwable)ex);
            }
        }
        this.setFinalSocketState();
        if (this.config.isWorkflowExecutorShouldClose().booleanValue()) {
            this.closeConnection();
        }
        if (this.config.isResetWorkflowTracesBeforeSaving().booleanValue()) {
            LOGGER.debug("Resetting WorkflowTrace");
            this.state.getWorkflowTrace().reset();
        }
        try {
            if (this.getAfterExecutionCallback() != null) {
                LOGGER.debug("Executing AfterExecutionCallback");
                this.getAfterExecutionCallback().apply(this.state);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error during AfterExecutionCallback", (Throwable)ex);
        }
    }

    private void sendConnectionCloseFrame(boolean handshakeComplete) throws IOException {
        ConnectionCloseFrame frame = new ConnectionCloseFrame(QuicTransportErrorCodes.NO_ERROR.getValue());
        SendAction sendAction = new SendAction(this.state.getWorkflowTrace().getConnections().get(0).getAlias());
        sendAction.setConfiguredQuicFrames(List.of(frame));
        if (handshakeComplete) {
            sendAction.setConfiguredQuicPackets(List.of(new OneRTTPacket()));
        } else {
            sendAction.setConfiguredQuicPackets(List.of(new InitialPacket()));
        }
        sendAction.addActionOption(ActionOption.MAY_FAIL);
        sendAction.execute(this.state);
    }

    private void executeRetransmission(SendingAction action) {
        if (this.shouldStopDueToErrorCondition()) {
            return;
        }
        LOGGER.info("Executing retransmission of last sent flight");
        QuicPacketLayer packetLayer = (QuicPacketLayer)this.state.getContext().getQuicContext().getLayerStack().getLayer(QuicPacketLayer.class);
        packetLayer.setLayerConfiguration(new SpecificSendLayerConfiguration<QuicPacket>((LayerType)ImplementedLayers.QUICPACKET, action.getSentQuicPackets()));
        try {
            packetLayer.sendConfiguration();
        }
        catch (IOException ex) {
            this.state.getTlsContext().setReceivedTransportHandlerException(true);
            LOGGER.warn("Received IOException during retransmission", (Throwable)ex);
        }
    }

    private boolean shouldStopDueToErrorCondition() {
        if (this.config.isStopActionAfterQuicConnCloseFrame().booleanValue() && this.hasReceivedConnectionCloseFrame()) {
            LOGGER.debug("Skipping all Actions, received ConnectionCloseFrame, StopActionsAfterConnCloseFrame active");
            return true;
        }
        if (this.config.stopActionAfterQuicStatelessReset() && this.hasReceivedStatelessReset()) {
            LOGGER.debug("Skipping all Actions, received StatelessReset, StopActionsAfterStatelessReset active");
            return true;
        }
        if (this.config.getStopActionsAfterIOException().booleanValue() && this.isIoException()) {
            LOGGER.debug("Skipping all Actions, received IO Exception, StopActionsAfterIOException active");
            return true;
        }
        return false;
    }

    public boolean hasReceivedConnectionCloseFrame() {
        for (Context ctx : this.state.getAllContexts()) {
            if (ctx.getQuicContext().getReceivedConnectionCloseFrame() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasReceivedStatelessReset() {
        for (Context ctx : this.state.getAllContexts()) {
            if (!ctx.getQuicContext().hasReceivedStatelessResetToken()) continue;
            return true;
        }
        return false;
    }
}

