/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorRunnable;
import de.rub.nds.tlsattacker.core.workflow.action.executor.WorkflowExecutorType;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadedServerWorkflowExecutor
extends WorkflowExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int BACKLOG = 50;
    private static final int POOL_SIZE = 3;
    private ServerSocket serverSocket;
    private final int bindPort;
    private List<Socket> sockets = new ArrayList<Socket>();
    private volatile boolean killed = true;
    private volatile boolean shutdown = true;
    protected final ExecutorService pool;

    public ThreadedServerWorkflowExecutor(State state, ExecutorService pool) {
        super(WorkflowExecutorType.THREADED_SERVER, state);
        this.bindPort = this.config.getDefaultServerConnection().getPort();
        this.pool = pool;
        this.addHook();
    }

    public ThreadedServerWorkflowExecutor(State state) {
        this(state, Executors.newFixedThreadPool(3));
    }

    private void addHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOGGER.info("Received shutdown signal, shutting down server.");
                ThreadedServerWorkflowExecutor.this.kill();
                LOGGER.info("Waiting for connections to be closed...");
                for (int watchDog = 3; !ThreadedServerWorkflowExecutor.this.shutdown && watchDog > 0; --watchDog) {
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Problem while waiting, could not sleep");
                    }
                }
                if (!ThreadedServerWorkflowExecutor.this.shutdown) {
                    LOGGER.debug("Forcing sockets to close");
                    ThreadedServerWorkflowExecutor.this.closeSockets();
                    ThreadedServerWorkflowExecutor.this.shutdownAndAwaitTermination();
                }
                LOGGER.debug("Server shutdown complete.");
            }
        });
    }

    @Override
    public void executeWorkflow() throws WorkflowExecutionException {
        this.initialize();
        String bindaddrStr = "any";
        if (this.getBoundAddress() != null) {
            bindaddrStr = this.getBoundAddress().toString();
        }
        LOGGER.info("Listening on {}:{}...", (Object)bindaddrStr, (Object)this.getBoundPort());
        LOGGER.info("--- use SIGINT to shutdown ---");
        try {
            while (!this.killed) {
                Socket socket = this.serverSocket.accept();
                this.handleClient(socket);
                this.sockets.add(socket);
            }
        }
        catch (IOException ex) {
            if (!this.killed) {
                throw new RuntimeException("Failed to accept connection");
            }
        }
        finally {
            this.closeSockets();
            this.shutdownAndAwaitTermination();
            this.shutdown = true;
            LOGGER.info("Server shutdown cleanly");
        }
    }

    protected void handleClient(Socket socket) {
        this.pool.execute(new WorkflowExecutorRunnable(this.state, socket, this));
    }

    public void clientDone(Socket socket) {
        if (socket == null) {
            throw new IllegalArgumentException("socket may not be null");
        }
        if (!this.sockets.contains(socket)) {
            throw new IllegalArgumentException("Unknown socket");
        }
        try {
            if (!socket.isClosed()) {
                socket.close();
            }
            this.sockets.remove(socket);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to close socket {}", (Object)socket);
        }
    }

    private void initialize() {
        LOGGER.info("Initializing server connection end at port {}", (Object)this.bindPort);
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            LOGGER.debug("Server socket already initialized");
            return;
        }
        try {
            this.serverSocket = new ServerSocket(this.bindPort, 50);
            this.serverSocket.setReuseAddress(true);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not instantiate server socket", ex);
        }
        this.killed = false;
        this.shutdown = false;
    }

    public void kill() {
        this.killed = true;
        this.closeSockets();
    }

    private synchronized void closeSockets() {
        for (Socket s : this.sockets.toArray(new Socket[0])) {
            LOGGER.debug("Closing socket {}", (Object)s);
            this.clientDone(s);
        }
        try {
            LOGGER.debug("Closing server socket ");
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to close server socket.");
        }
        LOGGER.info("All sockets closed");
    }

    public InetAddress getBoundAddress() {
        return this.serverSocket.getInetAddress();
    }

    public int getBoundPort() {
        return this.serverSocket.getLocalPort();
    }

    private void shutdownAndAwaitTermination() {
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
                this.pool.awaitTermination(60L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException ie) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

