/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.DefaultWorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.ThreadedServerWorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.ServerTcpTransportHandler;
import java.net.Socket;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkflowExecutorRunnable
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Socket socket;
    protected final State globalState;
    protected final ThreadedServerWorkflowExecutor parent;

    public WorkflowExecutorRunnable(State globalState, Socket socket, ThreadedServerWorkflowExecutor parent) {
        this.globalState = globalState;
        this.socket = socket;
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String loggingContextString = String.format("%s %s", this.socket.getLocalPort(), this.socket.getRemoteSocketAddress());
        try (CloseableThreadContext.Instance ctc = CloseableThreadContext.push((String)loggingContextString);){
            this.runInternal();
        }
        finally {
            this.parent.clientDone(this.socket);
        }
    }

    protected void runInternal() {
        LOGGER.info("Spawning workflow on socket {}", (Object)this.socket);
        WorkflowTrace localTrace = this.globalState.getWorkflowTraceCopy();
        State state = new State(this.globalState.getConfig(), localTrace);
        this.initConnectionForState(state);
        TlsContext serverCtx = state.getInboundContexts().get(0).getTlsContext();
        LOGGER.info("Exectuting workflow for {} ({})", (Object)this.socket, (Object)serverCtx);
        DefaultWorkflowExecutor workflowExecutor = new DefaultWorkflowExecutor(state);
        ((WorkflowExecutor)workflowExecutor).executeWorkflow();
        LOGGER.info("Workflow execution done on {} ({})", (Object)this.socket, (Object)serverCtx);
    }

    protected void initConnectionForState(State state) {
        Context serverCtx = state.getInboundContexts().get(0);
        AliasedConnection serverCon = serverCtx.getConnection();
        serverCon.setHostname(this.socket.getInetAddress().getHostAddress());
        serverCon.setIp(this.socket.getInetAddress().getHostAddress());
        serverCon.setPort(this.socket.getPort());
        ServerTcpTransportHandler th = new ServerTcpTransportHandler((Connection)serverCon, this.socket);
        serverCtx.getTcpContext().setTransportHandler((TransportHandler)th);
    }
}

