/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class ActionIO {
    private static final Logger LOGGER = LogManager.getLogger();
    private static JAXBContext context;

    private static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (context == null) {
            String packageName = "de.rub";
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder().includePackage(packageName)));
            Set tlsActionClasses = reflections.getSubTypesOf(TlsAction.class);
            HashSet<Class<WorkflowTrace>> classes = new HashSet<Class<WorkflowTrace>>();
            classes.add(WorkflowTrace.class);
            classes.addAll(tlsActionClasses);
            Set dataContainers = reflections.getSubTypesOf(DataContainer.class);
            classes.addAll(dataContainers);
            LOGGER.debug("Registering Classes in JAXBContext of ActionIO:");
            for (Class clazz : classes) {
                LOGGER.debug(clazz.getName());
            }
            context = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]));
        }
        return context;
    }

    public static void write(File file, TlsAction action) throws JAXBException, IOException {
        assert (file.exists() || file.createNewFile());
        try (FileOutputStream fos = new FileOutputStream(file);){
            ActionIO.write(fos, action);
        }
    }

    public static void write(OutputStream outputStream, TlsAction action) throws JAXBException, IOException {
        context = ActionIO.getJAXBContext();
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)action, outputStream);
    }

    public static TlsAction read(InputStream inputStream) throws JAXBException, IOException, XMLStreamException {
        context = ActionIO.getJAXBContext();
        Unmarshaller m = context.createUnmarshaller();
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = xif.createXMLStreamReader(inputStream);
        return (TlsAction)m.unmarshal(xsr);
    }

    public static TlsAction copyTlsAction(TlsAction tlsAction) throws JAXBException, IOException, XMLStreamException {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        ActionIO.write((OutputStream)stream, tlsAction);
        stream.flush();
        return ActionIO.read(new ByteArrayInputStream(stream.toByteArray()));
    }

    private ActionIO() {
    }
}

