/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeyDerivator;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ActivateEncryptionAction;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ActivateCryptoAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public boolean equals(Object o) {
        return o instanceof ActivateCryptoAction && super.equals(o);
    }

    @Override
    public int hashCode() {
        return 13 + super.hashCode();
    }

    protected abstract void activateCrypto(TlsContext var1, RecordCipher var2);

    @Override
    public void execute(State state) throws ActionExecutionException {
        KeySet keySet;
        TlsContext tlsContext = state.getContext(this.getConnectionAlias()).getTlsContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        try {
            keySet = KeyDerivator.generateKeySet(tlsContext);
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("The specified Algorithm is not supported", ex);
        }
        RecordCipher recordCipher = RecordCipherFactory.getRecordCipher(tlsContext, keySet, this instanceof ActivateEncryptionAction);
        this.activateCrypto(tlsContext, recordCipher);
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.setExecuted(null);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

