/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ChangeClientRandom")
public class ChangeClientRandomAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] newValue = null;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] oldValue = null;

    public ChangeClientRandomAction(byte[] newValue) {
        this.newValue = newValue;
    }

    public ChangeClientRandomAction() {
    }

    public void setNewValue(byte[] newValue) {
        this.newValue = newValue;
    }

    public byte[] getNewValue() {
        return this.newValue;
    }

    public byte[] getOldValue() {
        return this.oldValue;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext tlsContext = state.getContext(this.getConnectionAlias()).getTlsContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        this.oldValue = tlsContext.getClientRandom();
        tlsContext.setClientRandom(this.newValue);
        LOGGER.info("Changed ClientRandom from {} to {}", (Object)this.oldValue, (Object)this.newValue);
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.oldValue = null;
        this.setExecuted(null);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Arrays.hashCode(this.newValue);
        hash = 83 * hash + Arrays.hashCode(this.oldValue);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeClientRandomAction other = (ChangeClientRandomAction)obj;
        if (!Arrays.equals(this.newValue, other.newValue)) {
            return false;
        }
        return Arrays.equals(this.oldValue, other.oldValue);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

