/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.SuppressingFalseBooleanAdapter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeyDerivator;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ChangePreMasterSecret")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ChangePreMasterSecretAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] newValue = null;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] oldValue = null;
    @XmlJavaTypeAdapter(value=SuppressingFalseBooleanAdapter.class)
    private Boolean updateMasterSecret = null;
    @XmlTransient
    private boolean asPlanned = false;

    public ChangePreMasterSecretAction(byte[] newValue) {
        this.newValue = newValue;
    }

    public ChangePreMasterSecretAction(byte[] newValue, boolean updateMasterSecret) {
        this.newValue = newValue;
        this.updateMasterSecret = updateMasterSecret;
    }

    public ChangePreMasterSecretAction() {
    }

    public void setNewValue(byte[] newValue) {
        this.newValue = newValue;
    }

    public byte[] getNewValue() {
        return this.newValue;
    }

    public byte[] getOldValue() {
        return this.oldValue;
    }

    public boolean isUpdateMasterSecret() {
        return this.updateMasterSecret;
    }

    public void setUpdateMasterSecret(boolean updateMasterSecret) {
        this.updateMasterSecret = updateMasterSecret;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext tlsContext = state.getContext(this.getConnectionAlias()).getTlsContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        this.oldValue = tlsContext.getPreMasterSecret();
        tlsContext.setPreMasterSecret(this.newValue);
        LOGGER.info("Changed PreMasterSecret from {} to {}", (Object)this.oldValue, (Object)this.newValue);
        this.asPlanned = true;
        if (Boolean.TRUE.equals(this.updateMasterSecret)) {
            byte[] clientServerRandom = DataConverter.concatenate((byte[][])new byte[][]{tlsContext.getChooser().getClientRandom(), tlsContext.getChooser().getServerRandom()});
            try {
                byte[] newMasterSecret = KeyDerivator.calculateMasterSecret(tlsContext, clientServerRandom);
                LOGGER.info("Derived new master secret {} using clientServerRandom {}", (Object)newMasterSecret, (Object)clientServerRandom);
                tlsContext.setMasterSecret(newMasterSecret);
            }
            catch (CryptoException e) {
                this.asPlanned = false;
                LOGGER.error("Could not update master secret: {}", (Throwable)e);
            }
        }
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.oldValue = null;
        this.setExecuted(null);
        this.asPlanned = false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Arrays.hashCode(this.newValue);
        hash = 19 * hash + Arrays.hashCode(this.oldValue);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangePreMasterSecretAction other = (ChangePreMasterSecretAction)obj;
        if (!Arrays.equals(this.newValue, other.newValue)) {
            return false;
        }
        return Arrays.equals(this.oldValue, other.oldValue);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.asPlanned;
    }
}

