/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.http.HttpMessage;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.printer.LogPrinter;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.tcp.TcpStreamContainer;
import de.rub.nds.tlsattacker.core.udp.UdpDataPacket;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CommonReceiveAction
extends MessageAction
implements ReceivingAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public CommonReceiveAction() {
    }

    public CommonReceiveAction(String connectionAlias) {
        super(connectionAlias);
    }

    public CommonReceiveAction(Set<ActionOption> actionOptions, String connectionAlias) {
        super(actionOptions, connectionAlias);
    }

    public CommonReceiveAction(Set<ActionOption> actionOptions) {
        super(actionOptions);
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        LOGGER.debug("Receiving... ({})", (Object)this.getClass().getSimpleName());
        List<LayerConfiguration<?>> layerConfigurations = this.createLayerConfiguration(state);
        this.getReceiveResult(tlsContext.getLayerStack(), layerConfigurations);
        this.setExecuted(true);
        LOGGER.debug("Receive Expected: {}", (Object)LogPrinter.toHumanReadableOneLine(layerConfigurations, LOGGER.getLevel()));
        if (this.hasDefaultAlias()) {
            LOGGER.info("Received Messages: {}", (Object)LogPrinter.toHumanReadableMultiLine(this.getLayerStackProcessingResult(), LOGGER.getLevel()));
        } else {
            LOGGER.info("Received Messages ({}): {}", (Object)this.getConnectionAlias(), (Object)LogPrinter.toHumanReadableMultiLine(this.getLayerStackProcessingResult(), LOGGER.getLevel()));
        }
    }

    @Override
    public final MessageAction.MessageActionDirection getMessageDirection() {
        return MessageAction.MessageActionDirection.RECEIVING;
    }

    @Override
    public Set<String> getAllReceivingAliases() {
        return new HashSet<String>(Collections.singleton(this.connectionAlias));
    }

    protected abstract List<LayerConfiguration<?>> createLayerConfiguration(State var1);

    @Override
    public List<ProtocolMessage> getReceivedMessages() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.MESSAGE, this.getLayerStackProcessingResult()).stream().map(container -> (ProtocolMessage)container).collect(Collectors.toList());
    }

    @Override
    public List<SSL2Message> getReceivedSSL2Messages() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.SSL2, this.getLayerStackProcessingResult()).stream().map(container -> (SSL2Message)container).collect(Collectors.toList());
    }

    @Override
    public List<Record> getReceivedRecords() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.RECORD, this.getLayerStackProcessingResult()).stream().map(container -> (Record)container).collect(Collectors.toList());
    }

    @Override
    public List<DtlsHandshakeMessageFragment> getReceivedFragments() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.DTLS_FRAGMENT, this.getLayerStackProcessingResult()).stream().map(container -> (DtlsHandshakeMessageFragment)container).collect(Collectors.toList());
    }

    @Override
    public List<HttpMessage> getReceivedHttpMessages() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.HTTP, this.getLayerStackProcessingResult()).stream().map(container -> (HttpMessage)container).collect(Collectors.toList());
    }

    @Override
    public List<QuicFrame> getReceivedQuicFrames() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.QUICFRAME, this.getLayerStackProcessingResult()).stream().map(container -> (QuicFrame)container).collect(Collectors.toList());
    }

    @Override
    public List<QuicPacket> getReceivedQuicPackets() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.QUICPACKET, this.getLayerStackProcessingResult()).stream().map(container -> (QuicPacket)container).collect(Collectors.toList());
    }

    @Override
    public List<TcpStreamContainer> getReceivedTcpStreamContainers() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.TCP, this.getLayerStackProcessingResult()).stream().map(container -> (TcpStreamContainer)container).collect(Collectors.toList());
    }

    @Override
    public List<UdpDataPacket> getReceivedUdpDataPackets() {
        if (this.getLayerStackProcessingResult() == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.UDP, this.getLayerStackProcessingResult()).stream().map(container -> (UdpDataPacket)container).collect(Collectors.toList());
    }

    @Override
    public boolean executedAsPlanned() {
        if (this.isExecuted() && this.getLayerStackProcessingResult() != null) {
            boolean executedAsPlanned = this.getLayerStackProcessingResult().executedAsPlanned();
            return executedAsPlanned;
        }
        return false;
    }
}

