/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

@XmlType(propOrder={"srcConnectionAlias", "dstConnectionAlias"})
public abstract class CopyContextFieldAction
extends TlsAction {
    @XmlElement(name="from")
    private String srcConnectionAlias;
    @XmlElement(name="to")
    private String dstConnectionAlias;

    public CopyContextFieldAction() {
    }

    public CopyContextFieldAction(String srcConnectionAlias, String dstConnectionAlias) {
        this.srcConnectionAlias = srcConnectionAlias;
        this.dstConnectionAlias = dstConnectionAlias;
    }

    protected abstract void copyField(TlsContext var1, TlsContext var2);

    @Override
    public void execute(State state) throws ActionExecutionException {
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        if (this.srcConnectionAlias == null || this.dstConnectionAlias == null) {
            throw new ActionExecutionException("Cannot execute, at least one context alias is null!");
        }
        TlsContext src = state.getContext(this.srcConnectionAlias).getTlsContext();
        TlsContext dst = state.getContext(this.dstConnectionAlias).getTlsContext();
        this.copyField(src, dst);
        this.setExecuted(true);
    }

    public String getSrcContextAlias() {
        return this.srcConnectionAlias;
    }

    public String getDstContextAlias() {
        return this.dstConnectionAlias;
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.srcConnectionAlias);
        hash = 53 * hash + Objects.hashCode(this.dstConnectionAlias);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CopyContextFieldAction other = (CopyContextFieldAction)obj;
        if (!Objects.equals(this.srcConnectionAlias, other.srcConnectionAlias)) {
            return false;
        }
        return Objects.equals(this.dstConnectionAlias, other.dstConnectionAlias);
    }

    @Override
    public Set<String> getAllAliases() {
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        aliases.add(this.srcConnectionAlias);
        aliases.add(this.dstConnectionAlias);
        return aliases;
    }

    @Override
    public void assertAliasesSetProperly() throws ConfigurationException {
        if (this.srcConnectionAlias == null || this.srcConnectionAlias.isEmpty()) {
            throw new ActionExecutionException("Can't execute " + this.getClass().getSimpleName() + " with empty src alias (if using XML: add <from/>)");
        }
        if (this.dstConnectionAlias == null || this.dstConnectionAlias.isEmpty()) {
            throw new ActionExecutionException("Can't execute " + this.getClass().getSimpleName() + " with empty dst alias (if using XML: add <to/>)");
        }
    }
}

