/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.workflow.action.CopyContextFieldAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="DeepCopyBufferedRecords")
public class DeepCopyBufferedRecordsAction
extends CopyContextFieldAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public DeepCopyBufferedRecordsAction() {
    }

    public DeepCopyBufferedRecordsAction(String srcConnectionAlias, String dstConnectionAlias) {
        super(srcConnectionAlias, dstConnectionAlias);
    }

    @Override
    protected void copyField(TlsContext src, TlsContext dst) {
        this.deepCopyRecords(src, dst);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }

    private void deepCopyRecords(TlsContext src, TlsContext dst) {
        LinkedList<Record> recordBuffer = new LinkedList<Record>();
        try {
            for (Record record : src.getRecordBuffer()) {
                SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
                ObjectOutputStream outStream = new ObjectOutputStream((OutputStream)stream);
                outStream.writeObject(record);
                ObjectInputStream inStream = new ObjectInputStream(new ByteArrayInputStream(stream.toByteArray()));
                Record recordCopy = (Record)inStream.readObject();
                recordBuffer.add(recordCopy);
                this.setExecuted(true);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            this.setExecuted(this.getActionOptions().contains((Object)ActionOption.MAY_FAIL));
            LOGGER.error("Error while creating deep copy of recordBuffer");
            throw new ActionExecutionException(ex.toString());
        }
        dst.setRecordBuffer(recordBuffer);
    }
}

