/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EsniKeyRecord;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.EsniKeyRecordParser;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

@XmlRootElement(name="EsniKeyDnsRequest")
public class EsniKeyDnsRequestAction
extends TlsAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean asPlanned = false;

    @Override
    public void execute(State state) throws ActionExecutionException {
        byte[] esniKeyRecordBytes;
        Message answer;
        Name domainName;
        SimpleResolver resolver;
        TlsContext tlsContext = state.getTlsContext();
        Config tlsConfig = state.getConfig();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        String hostname = "_esni." + tlsConfig.getDefaultClientConnection().getHostname();
        try {
            resolver = new SimpleResolver(tlsConfig.getDefaultDnsServer());
            domainName = Name.fromString((String)(hostname + "."));
        }
        catch (TextParseException e) {
            LOGGER.error("Cannot send DNS query for ip addresses");
            this.setExecuted(true);
            this.asPlanned = false;
            return;
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Could not reach Cloudflare DNS server");
            this.setExecuted(true);
            this.asPlanned = false;
            return;
        }
        Record record = Record.newRecord((Name)domainName, (int)16, (int)1);
        Message message = Message.newQuery((Record)record);
        LOGGER.debug("Sending DNS request to get ESNI Resource Record for: {}", (Object)hostname);
        try {
            answer = resolver.send(message);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to send DNS query");
            this.setExecuted(true);
            this.asPlanned = false;
            return;
        }
        List esniKeyRecords = new LinkedList();
        List records = answer.getSection(1);
        for (Record receivedRecord : records) {
            if (receivedRecord.getType() != 16) continue;
            TXTRecord txtRecord = (TXTRecord)receivedRecord;
            esniKeyRecords = txtRecord.getStrings();
        }
        if (esniKeyRecords.isEmpty()) {
            LOGGER.warn("No ESNI DNS Resource Record available for {}", (Object)hostname);
            this.setExecuted(true);
            this.asPlanned = false;
            return;
        }
        String esniKeyRecordStr = (String)esniKeyRecords.get(0);
        try {
            esniKeyRecordBytes = Base64.getMimeDecoder().decode(esniKeyRecordStr);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Failed to base64 decode Resource Record for {}. Resource Record: {}", (Object)hostname, (Object)esniKeyRecordStr);
            this.setExecuted(true);
            this.asPlanned = false;
            return;
        }
        LOGGER.debug("esniKeyRecordStr: {}", (Object)esniKeyRecordStr);
        LOGGER.debug("esniKeyRecordBytes: {}", (Object)esniKeyRecordBytes);
        EsniKeyRecordParser esniKeyParser = new EsniKeyRecordParser(new ByteArrayInputStream(esniKeyRecordBytes), tlsContext);
        EsniKeyRecord esniKeyRecord = new EsniKeyRecord();
        esniKeyParser.parse(esniKeyRecord);
        tlsContext.setEsniRecordBytes(esniKeyRecordBytes);
        tlsContext.setEsniRecordVersion(esniKeyRecord.getVersion());
        tlsContext.setEsniRecordChecksum(esniKeyRecord.getChecksum());
        tlsContext.setPublicName(esniKeyRecord.getPublicName());
        tlsContext.setEsniServerKeyShareEntries(esniKeyRecord.getKeys());
        tlsContext.setEsniServerCipherSuites(esniKeyRecord.getCipherSuites());
        tlsContext.setEsniPaddedLength(esniKeyRecord.getPaddedLength());
        tlsContext.setEsniKeysNotBefore(esniKeyRecord.getNotBefore());
        tlsContext.setEsniKeysNotAfter(esniKeyRecord.getNotAfter());
        this.asPlanned = true;
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.setExecuted(false);
        this.asPlanned = false;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted() && this.asPlanned;
    }
}

