/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceResultUtil;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="FindReceivedProtocolMessage")
public class FindReceivedProtocolMessageAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private ProtocolMessageType protocolMessageType;
    private Boolean found = false;

    public FindReceivedProtocolMessageAction() {
    }

    public FindReceivedProtocolMessageAction(ProtocolMessageType protocolMessageType) {
        this.protocolMessageType = protocolMessageType;
    }

    public FindReceivedProtocolMessageAction(String alias, ProtocolMessageType protocolMessageType) {
        super(alias);
        this.protocolMessageType = protocolMessageType;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        this.found = WorkflowTraceResultUtil.didReceiveMessage(state.getWorkflowTrace(), this.protocolMessageType);
        if (this.found.booleanValue()) {
            LOGGER.info("Found {} ({})", (Object)this.protocolMessageType.name(), (Object)this.protocolMessageType.getValue());
        }
        this.setExecuted(Boolean.TRUE);
    }

    public ProtocolMessageType getProtocolMessageType() {
        return this.protocolMessageType;
    }

    public void setProtocolMessageType(ProtocolMessageType protocolMessageType) {
        this.protocolMessageType = protocolMessageType;
    }

    public Boolean isFound() {
        return this.found;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }
}

