/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.layer.GenericReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerStackProcessingResult;
import de.rub.nds.tlsattacker.core.layer.SpecificSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonForwardAction;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ForwardData")
public class ForwardDataAction
extends CommonForwardAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public ForwardDataAction() {
    }

    public ForwardDataAction(String receiveFromAlias, String forwardToAlias) {
        super(receiveFromAlias, forwardToAlias);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Forward Data Action:\n");
        sb.append("Receive from alias: ").append(this.receiveFromAlias).append("\n");
        sb.append("\n\tReceived:");
        if (this.getReceivedRecords() != null && !this.getReceivedRecords().isEmpty()) {
            for (Record record : this.getReceivedRecords()) {
                sb.append(record.toCompactString());
                sb.append(", ");
            }
        } else {
            sb.append(" (no records set)");
        }
        sb.append("\n");
        sb.append("Forwarded to alias: ").append(this.forwardToAlias).append("\n");
        if (this.getSentRecords() != null) {
            sb.append("\t");
            for (Record record : this.getSentRecords()) {
                sb.append(record.toCompactString());
                sb.append(", ");
            }
            sb.append("\n");
        } else {
            sb.append("null (no records set)");
        }
        return sb.toString();
    }

    @Override
    protected List<LayerConfiguration<?>> createReceiveConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getReceiveFromAlias());
        LinkedList configurationList = new LinkedList();
        configurationList.add(new GenericReceiveLayerConfiguration(ImplementedLayers.TCP));
        configurationList.add(new GenericReceiveLayerConfiguration(ImplementedLayers.UDP));
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), false, this.getActionOptions(), configurationList);
    }

    @Override
    protected List<LayerConfiguration<?>> createSendConfiguration(State state, LayerStackProcessingResult receivedResult) {
        TlsContext tlsContext = state.getTlsContext(this.getForwardToAlias());
        List<Record> receivedRecords = this.getReceivedRecords();
        for (Record record : receivedRecords) {
            record.setShouldPrepare(false);
        }
        LinkedList configurationList = new LinkedList();
        configurationList.add(new SpecificSendLayerConfiguration<Record>((LayerType)ImplementedLayers.RECORD, receivedRecords));
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), true, this.getActionOptions(), configurationList);
    }
}

