/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerStackProcessingResult;
import de.rub.nds.tlsattacker.core.layer.SpecificReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonForwardAction;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement(name="ForwardRecords")
public class ForwardRecordsAction
extends CommonForwardAction {
    @XmlElementWrapper
    @HoldsModifiableVariable
    @XmlElementRef
    protected List<Record> expectedRecords;

    public ForwardRecordsAction() {
    }

    public ForwardRecordsAction(String receiveFromAlias, String forwardToAlias, List<Record> expectedRecords) {
        super(receiveFromAlias, forwardToAlias);
        this.expectedRecords = expectedRecords;
    }

    public ForwardRecordsAction(String receiveFromAlias, String forwardToAlias, Record ... expectedRecords) {
        this(receiveFromAlias, forwardToAlias, new ArrayList<Record>(Arrays.asList(expectedRecords)));
    }

    public List<Record> getExpectedRecords() {
        return this.expectedRecords;
    }

    public void setExpectedRecords(List<Record> expectedRecords) {
        this.expectedRecords = expectedRecords;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Forward Records Action:\n");
        sb.append("Receive from alias: ").append(this.receiveFromAlias).append("\n");
        sb.append("\tExpected:");
        if (this.expectedRecords != null) {
            for (Record record : this.expectedRecords) {
                sb.append(", ");
                sb.append(record.toCompactString());
            }
        } else {
            sb.append(" (no records set)");
        }
        sb.append("\n\tActual:");
        if (this.getReceivedRecords() != null && !this.getReceivedRecords().isEmpty()) {
            for (Record record : this.getReceivedRecords()) {
                sb.append(record.toCompactString());
                sb.append(", ");
            }
        } else {
            sb.append(" (no records set)");
        }
        sb.append("\n");
        sb.append("Forwarded to alias: ").append(this.forwardToAlias).append("\n");
        if (this.getSentRecords() != null) {
            sb.append("\t");
            for (Record record : this.getSentRecords()) {
                sb.append(record.toCompactString());
                sb.append(", ");
            }
            sb.append("\n");
        } else {
            sb.append("null (no records set)");
        }
        return sb.toString();
    }

    @Override
    protected List<LayerConfiguration<?>> createReceiveConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getReceiveFromAlias());
        List<LayerConfiguration<?>> configurationList = List.of(new SpecificReceiveLayerConfiguration<Record>((LayerType)ImplementedLayers.RECORD, this.getExpectedRecords()));
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), false, this.getActionOptions(), configurationList);
    }

    @Override
    protected List<LayerConfiguration<?>> createSendConfiguration(State state, LayerStackProcessingResult receivedResult) {
        TlsContext tlsContext = state.getTlsContext(this.getForwardToAlias());
        List<Record> receivedRecords = this.getReceivedRecords();
        for (Record record : receivedRecords) {
            record.setShouldPrepare(false);
        }
        LinkedList configurationList = new LinkedList();
        configurationList.add(new SpecificSendLayerConfiguration<Record>((LayerType)ImplementedLayers.RECORD, receivedRecords));
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), true, this.getActionOptions(), configurationList);
    }
}

