/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.layer.GenericReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.printer.LogPrinter;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="GenericReceive")
public class GenericReceiveAction
extends CommonReceiveAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public GenericReceiveAction() {
    }

    public GenericReceiveAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        LinkedList configurationList = new LinkedList();
        configurationList.add(new GenericReceiveLayerConfiguration(ImplementedLayers.SSL2));
        configurationList.add(new GenericReceiveLayerConfiguration(ImplementedLayers.MESSAGE));
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), false, this.getActionOptions(), configurationList);
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + ": " + (this.isExecuted() ? "\n" : "(not executed)\n");
        if (this.isExecuted()) {
            string = string + "\n\tReceived: " + LogPrinter.toHumanReadableMultiLine(this.getLayerStackProcessingResult(), LOGGER.getLevel());
        }
        return string;
    }
}

