/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.printer.LogPrinter;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonSendAction;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="PopAndSend")
public class PopAndSendAction
extends CommonSendAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private Integer index = null;
    private boolean couldPop = false;

    public PopAndSendAction() {
    }

    public PopAndSendAction(String connectionAlias) {
        super(connectionAlias);
    }

    public PopAndSendAction(String connectionAlias, int index) {
        super(connectionAlias);
        this.index = index;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        super.execute(state);
        this.couldPop = !this.getSentMessages().isEmpty();
    }

    public String toString() {
        String messageString = LogPrinter.toHumanReadableContainerList(ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.MESSAGE, this.getLayerStackProcessingResult()), LOGGER.getLevel());
        return "PopAndSendAction: index: " + this.index + " message: " + messageString + " executed: " + this.isExecuted() + " couldPop: " + this.couldPop + " connectionAlias: " + this.connectionAlias;
    }

    @Override
    public boolean executedAsPlanned() {
        return super.executedAsPlanned() && this.couldPop;
    }

    @Override
    public void reset() {
        super.reset();
        this.couldPop = false;
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        LinkedList<ProtocolMessage> messages = new LinkedList<ProtocolMessage>();
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        LinkedList<ProtocolMessage> messageBuffer = tlsContext.getMessageBuffer();
        if (this.index != null && this.index >= 0) {
            if (this.index >= messageBuffer.size()) {
                throw new WorkflowExecutionException("Index out of bounds, trying to get element " + this.index + "of message buffer with " + messageBuffer.size() + "elements.");
            }
            messages.add(messageBuffer.get(this.index));
            messageBuffer.remove(this.index);
            tlsContext.getRecordBuffer().remove(this.index);
        } else if (!messageBuffer.isEmpty()) {
            messages.add(messageBuffer.pop());
        }
        LinkedList configurationList = new LinkedList();
        configurationList.add(new SpecificSendLayerConfiguration((LayerType)ImplementedLayers.MESSAGE, messages));
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), true, this.getActionOptions(), configurationList);
    }
}

