/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="PrintSecrets")
public class PrintSecretsAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public PrintSecretsAction() {
    }

    public PrintSecretsAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext context = state.getContext(this.connectionAlias).getTlsContext();
        StringBuilder builder = new StringBuilder("\n\nContext: " + String.valueOf(context));
        builder.append("\n  (Record Layer) ");
        if (context.getSelectedCipherSuite() == null) {
            builder.append("\n  CipherSuite: null");
        } else {
            builder.append("\n  CipherSuite: ").append(context.getSelectedCipherSuite().name());
        }
        builder.append("\n  (RSA Key Exchange) ");
        if (context.getChooser().getContext().getTlsContext().getServerX509Context().getSubjectRsaPublicExponent() == null) {
            builder.append("\n  ServerRsaPublicKey (chooser): null");
        } else {
            builder.append("\n  ServerRsaPublicKey (chooser): ");
            builder.append(context.getChooser().getContext().getTlsContext().getServerX509Context().getSubjectRsaPublicExponent());
        }
        if (context.getChooser().getContext().getTlsContext().getServerX509Context().getSubjectRsaModulus() == null) {
            builder.append("\n  ServerRsaModulus(chooser): null");
        } else {
            builder.append("\n  ServerRsaModulus (chooser): ");
            builder.append(this.toHex(DataConverter.bigIntegerToByteArray((BigInteger)context.getChooser().getContext().getTlsContext().getServerX509Context().getSubjectRsaModulus())));
        }
        builder.append("\n\n  (Handshake) ");
        builder.append("\n  Client Random: ").append(this.toHex(context.getClientRandom()));
        builder.append("\n  Server Random: ").append(this.toHex(context.getServerRandom()));
        builder.append("\n  PreMasterSecret: ").append(this.toHex(context.getPreMasterSecret()));
        builder.append("\n  MasterSecret: ").append(this.toHex(context.getMasterSecret()));
        if (context.getLastClientVerifyData() == null) {
            builder.append("\n  LastClientVerifyData: null");
        } else {
            builder.append("\n  LastClientVerifyData: ").append(this.toHex(context.getLastClientVerifyData()));
        }
        if (context.getLastServerVerifyData() == null) {
            builder.append("\n  LastServerVerifyData: null");
        } else {
            builder.append("\n  LastServerVerifyData: ").append(this.toHex(context.getLastServerVerifyData()));
        }
        LOGGER.info(builder.append("\n").toString());
    }

    private String toHex(byte[] bytes) {
        return DataConverter.bytesToRawHexString((byte[])bytes);
    }

    @Override
    public boolean executedAsPlanned() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void reset() {
    }
}

