/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.ReceiveTillLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@XmlRootElement
public class ReceiveQuicTillAction
extends CommonReceiveAction {
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<QuicFrame> expectedQuicFrames = null;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<QuicPacket> expectedQuicPackets = null;

    public ReceiveQuicTillAction() {
    }

    public ReceiveQuicTillAction(QuicFrame ... expectedQuicFrames) {
        this.expectedQuicFrames = new ArrayList<QuicFrame>(Arrays.asList(expectedQuicFrames));
    }

    public ReceiveQuicTillAction(QuicPacket ... expectedQuicPackets) {
        this.expectedQuicPackets = new ArrayList<QuicPacket>(Arrays.asList(expectedQuicPackets));
    }

    public ReceiveQuicTillAction(ActionOption actionOption, QuicFrame ... expectedQuicFrames) {
        super(Set.of(actionOption));
        this.expectedQuicFrames = new ArrayList<QuicFrame>(Arrays.asList(expectedQuicFrames));
    }

    public ReceiveQuicTillAction(ActionOption actionOption, QuicPacket ... expectedQuicPackets) {
        super(Set.of(actionOption));
        this.expectedQuicPackets = new ArrayList<QuicPacket>(Arrays.asList(expectedQuicPackets));
    }

    public ReceiveQuicTillAction(ActionOption actionOption, List<QuicFrame> expectedQuicFrames, List<QuicPacket> expectedQuicPackets) {
        super(Set.of(actionOption));
        this.expectedQuicFrames = expectedQuicFrames;
        this.expectedQuicPackets = expectedQuicPackets;
    }

    public ReceiveQuicTillAction(Set<ActionOption> actionOptions, List<QuicFrame> expectedQuicFrames, List<QuicPacket> expectedQuicPackets) {
        super(actionOptions);
        this.expectedQuicFrames = expectedQuicFrames;
        this.expectedQuicPackets = expectedQuicPackets;
    }

    public List<QuicFrame> getExpectedQuicFrames() {
        return this.expectedQuicFrames;
    }

    public void setExpectedQuicFrames(List<QuicFrame> expectedQuicFrames) {
        this.expectedQuicFrames = expectedQuicFrames;
    }

    public List<QuicPacket> getExpectedQuicPackets() {
        return this.expectedQuicPackets;
    }

    public void setExpectedQuicPackets(List<QuicPacket> expectedQuicPackets) {
        this.expectedQuicPackets = expectedQuicPackets;
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        LinkedList configurationList = new LinkedList();
        if (this.expectedQuicFrames != null) {
            configurationList.add(new ReceiveTillLayerConfiguration<QuicFrame>((LayerType)ImplementedLayers.QUICFRAME, true, this.expectedQuicFrames));
        }
        if (this.expectedQuicPackets != null) {
            configurationList.add(new ReceiveTillLayerConfiguration<QuicPacket>((LayerType)ImplementedLayers.QUICPACKET, this.expectedQuicPackets));
        }
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), false, this.getActionOptions(), configurationList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Quic Receive Until:\n");
        sb.append("\tExpected: ");
        if (this.expectedQuicPackets != null) {
            sb.append("Packets: ");
            for (QuicPacket packet : this.expectedQuicPackets) {
                sb.append(packet.toCompactString());
                sb.append(", ");
            }
        }
        if (this.expectedQuicFrames != null) {
            sb.append("Frames: ");
            for (QuicFrame frame : this.expectedQuicFrames) {
                sb.append(frame.toCompactString());
                sb.append(", ");
            }
        }
        if (this.expectedQuicPackets == null && this.expectedQuicFrames == null) {
            sb.append(" (no frames or packets set)");
        }
        sb.append("\n\tActual:");
        if (this.expectedQuicPackets != null && !this.expectedQuicPackets.isEmpty()) {
            if (this.getReceivedQuicPackets() != null && !this.getReceivedQuicPackets().isEmpty()) {
                for (QuicPacket packet : this.getReceivedQuicPackets()) {
                    sb.append(packet.toCompactString());
                    sb.append(", ");
                }
            } else {
                sb.append(" (no packets received)");
            }
        }
        if (this.expectedQuicFrames != null && !this.expectedQuicFrames.isEmpty()) {
            if (this.getExpectedQuicFrames() != null && !this.getExpectedQuicFrames().isEmpty()) {
                for (QuicFrame frames : this.getExpectedQuicFrames()) {
                    sb.append(frames.toCompactString());
                    sb.append(", ");
                }
            } else {
                sb.append(" (no frames received)");
            }
        }
        if (this.executedAsPlanned()) {
            sb.append("\n\t\tExecuted as planned.");
        } else {
            sb.append("\n\t\tNot executed as planned.");
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder(super.toCompactString());
        sb.append(" (");
        if (this.expectedQuicPackets != null) {
            for (QuicPacket packet : this.expectedQuicPackets) {
                sb.append(packet.toCompactString());
                sb.append(", ");
            }
        }
        if (this.expectedQuicFrames != null) {
            for (QuicFrame frame : this.expectedQuicFrames) {
                sb.append(frame.toCompactString());
                sb.append(", ");
            }
        }
        if (this.expectedQuicPackets == null || this.expectedQuicFrames == null) {
            sb.append(" (no messages set)");
        }
        return sb.toString();
    }

    private boolean matchByClassCount(List<?> expected, List<?> received) {
        HashMap expectedCount = new HashMap();
        HashMap receivedCount = new HashMap();
        for (Object obj : expected) {
            if (obj == null) continue;
            expectedCount.merge(obj.getClass(), 1, Integer::sum);
        }
        for (Object obj : received) {
            if (obj == null) continue;
            receivedCount.merge(obj.getClass(), 1, Integer::sum);
        }
        for (Map.Entry entry : expectedCount.entrySet()) {
            if (receivedCount.getOrDefault(entry.getKey(), 0) >= (Integer)entry.getValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean executedAsPlanned() {
        if (this.expectedQuicPackets != null && !this.expectedQuicPackets.isEmpty()) {
            if (this.getReceivedQuicPackets() == null || this.getReceivedQuicPackets().isEmpty()) {
                return false;
            }
            if (!this.matchByClassCount(this.expectedQuicPackets, this.getReceivedQuicPackets())) {
                return false;
            }
        }
        if (this.expectedQuicFrames != null && !this.expectedQuicFrames.isEmpty()) {
            if (this.getReceivedQuicFrames() == null || this.getReceivedQuicFrames().isEmpty()) {
                return false;
            }
            if (!this.matchByClassCount(this.expectedQuicFrames, this.getReceivedQuicFrames())) {
                return false;
            }
        }
        return true;
    }
}

