/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ReceiveRaw")
public class ReceiveRawAction
extends MessageAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] expectedData;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] receivedData;

    private ReceiveRawAction() {
    }

    @Override
    public MessageAction.MessageActionDirection getMessageDirection() {
        return MessageAction.MessageActionDirection.RECEIVING;
    }

    public ReceiveRawAction(byte[] expectedData) {
        this.expectedData = expectedData;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TransportHandler transportHandler = state.getContext().getTransportHandler();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        try {
            LOGGER.debug("Receiving raw message...");
            this.receivedData = transportHandler.fetchData();
            LOGGER.info("Received: {}", (Object)DataConverter.bytesToHexString((byte[])this.receivedData));
            this.setExecuted(true);
        }
        catch (IOException e) {
            LOGGER.debug((Object)e);
            this.setExecuted(this.getActionOptions().contains((Object)ActionOption.MAY_FAIL));
        }
    }

    public byte[] getExpectedData() {
        return this.expectedData;
    }

    public void setExpectedData(byte[] expectedData) {
        this.expectedData = expectedData;
    }

    public byte[] getReceivedData() {
        return this.receivedData;
    }

    @Override
    public void reset() {
        this.setExecuted(null);
    }

    @Override
    public boolean executedAsPlanned() {
        return Arrays.equals(this.receivedData, this.expectedData);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReceiveRawAction that = (ReceiveRawAction)o;
        return Arrays.equals(this.expectedData, that.expectedData) && Arrays.equals(this.receivedData, that.receivedData);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.expectedData);
        result = 31 * result + Arrays.hashCode(this.receivedData);
        return result;
    }
}

