/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.impl.QuicFrameLayer;
import de.rub.nds.tlsattacker.core.layer.impl.QuicPacketLayer;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ResetConnection")
public class ResetConnectionAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private Boolean asPlanned;
    private Boolean resetContext = true;
    private Boolean switchToIpv6 = false;

    public ResetConnectionAction() {
    }

    public ResetConnectionAction(boolean resetContext) {
        this.resetContext = resetContext;
    }

    public ResetConnectionAction(boolean resetContext, boolean switchToIpv6) {
        this.resetContext = resetContext;
        this.switchToIpv6 = switchToIpv6;
    }

    public ResetConnectionAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        Context context = state.getContext(this.getConnectionAlias());
        TlsContext tlsContext = context.getTlsContext();
        TransportHandler transportHandler = context.getTransportHandler();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        LOGGER.info("Terminating Connection");
        try {
            transportHandler.closeClientConnection();
        }
        catch (IOException ex) {
            LOGGER.debug("Could not close client connection", (Throwable)ex);
        }
        if (this.resetContext.booleanValue()) {
            LOGGER.info("Resetting Cipher");
            if (tlsContext.getRecordLayer() != null) {
                tlsContext.getRecordLayer().resetDecryptor();
                tlsContext.getRecordLayer().resetEncryptor();
                tlsContext.getRecordLayer().updateDecryptionCipher(RecordCipherFactory.getNullCipher(tlsContext));
                tlsContext.getRecordLayer().updateEncryptionCipher(RecordCipherFactory.getNullCipher(tlsContext));
                tlsContext.getRecordLayer().setWriteEpoch(0);
                tlsContext.getRecordLayer().setReadEpoch(0);
            }
            LOGGER.info("Resetting KeyShareStores");
            tlsContext.setServerKeyShareStoreEntry(null);
            tlsContext.setClientKeyShareStoreEntryList(null);
            LOGGER.info("Resetting SecureRenegotiation");
            tlsContext.setLastClientVerifyData(null);
            tlsContext.setLastServerVerifyData(null);
            LOGGER.info("Resetting MessageDigest");
            tlsContext.getDigest().reset();
            LOGGER.info("Resetting ActiveKeySets");
            tlsContext.setActiveClientKeySetType(Tls13KeySetType.NONE);
            tlsContext.setActiveServerKeySetType(Tls13KeySetType.NONE);
            LOGGER.info("Resetting TLS 1.3 HRR and PSK values");
            tlsContext.setExtensionCookie(null);
            tlsContext.setLastClientHello(null);
            tlsContext.setPsk(null);
            tlsContext.setEarlyDataPSKIdentity(null);
            tlsContext.setEarlyDataPsk(null);
            tlsContext.setEarlySecret(null);
            tlsContext.setEarlyDataCipherSuite(null);
            LOGGER.info("Resetting DTLS numbers and cookie");
            tlsContext.setDtlsCookie(null);
            tlsContext.getDtlsReceivedChangeCipherSpecEpochs().clear();
            tlsContext.getDtlsReceivedHandshakeMessageSequences().clear();
            tlsContext.getDtlsReceivedChangeCipherSpecEpochs().clear();
            tlsContext.getDtlsReceivedHandshakeMessageSequences().clear();
            tlsContext.setDtlsCookie(null);
            if (tlsContext.getDtlsFragmentLayer() != null) {
                tlsContext.getDtlsFragmentLayer().resetFragmentManager(state.getConfig());
                tlsContext.getDtlsFragmentLayer().setReadHandshakeMessageSequence(0);
                tlsContext.getDtlsFragmentLayer().setWriteHandshakeMessageSequence(0);
            }
            LOGGER.info("Resetting QUIC settings");
            if (context.getConfig().getQuic().booleanValue()) {
                QuicContext quicContext = context.getQuicContext();
                quicContext.reset();
                ((QuicPacketLayer)context.getLayerStack().getLayer(QuicPacketLayer.class)).clearReceivedPacketBuffer();
                ((QuicFrameLayer)context.getLayerStack().getLayer(QuicFrameLayer.class)).clearCryptoFrameBuffer();
            }
        }
        LOGGER.info("Reopening Connection");
        try {
            if (this.switchToIpv6.booleanValue()) {
                transportHandler.setUseIpv6(true);
            }
            transportHandler.initialize();
            this.asPlanned = true;
        }
        catch (IOException ex) {
            LOGGER.debug("Could not initialize TransportHandler", (Throwable)ex);
            this.asPlanned = false;
        }
        this.setExecuted(true);
    }

    public String toString() {
        return "RestConnectionAction: " + (this.isExecuted() ? "\n" : "(not executed)\n") + "\tReset context: " + this.resetContext + "\n\tSwitch to ipv6: " + this.switchToIpv6;
    }

    @Override
    public void reset() {
        this.setExecuted(false);
        this.asPlanned = null;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted() && Objects.equals(this.asPlanned, Boolean.TRUE);
    }
}

