/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.http.HttpMessage;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.printer.LogPrinter;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonSendAction;
import de.rub.nds.tlsattacker.core.workflow.action.StaticSendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="Send")
public class SendAction
extends CommonSendAction
implements StaticSendingAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<ProtocolMessage> configuredMessages;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<SSL2Message> configuredSSL2Messages;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<DtlsHandshakeMessageFragment> configuredDtlsHandshakeMessageFragments;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<Record> configuredRecords;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<HttpMessage> configuredHttpMessages;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<QuicFrame> configuredQuicFrames;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElementRef
    protected List<QuicPacket> configuredQuicPackets;

    public SendAction() {
    }

    public SendAction(List<ProtocolMessage> configuredMessages, List<QuicFrame> configuredQuicFrames, List<QuicPacket> configuredQuicPackets) {
        this.configuredMessages = configuredMessages;
        this.configuredQuicFrames = configuredQuicFrames;
        this.configuredQuicPackets = configuredQuicPackets;
    }

    public SendAction(ActionOption option, List<ProtocolMessage> configuredMessages, List<QuicFrame> configuredQuicFrames, List<QuicPacket> configuredQuicPackets) {
        this(configuredMessages, configuredQuicFrames, configuredQuicPackets);
        if (option != null) {
            this.addActionOption(option);
        }
    }

    public SendAction(ActionOption option, List<ProtocolMessage> configuredMessages) {
        this(configuredMessages);
        if (option != null) {
            this.addActionOption(option);
        }
    }

    public SendAction(ActionOption option, ProtocolMessage ... configuredMessages) {
        this(option, new ArrayList<ProtocolMessage>(Arrays.asList(configuredMessages)));
    }

    public SendAction(List<ProtocolMessage> configuredMessages) {
        this.configuredMessages = configuredMessages;
    }

    public SendAction(QuicPacket ... configuredQuicPackets) {
        this.configuredQuicPackets = new ArrayList<QuicPacket>(Arrays.asList(configuredQuicPackets));
    }

    public SendAction(QuicFrame ... configuredQuicFrames) {
        this.configuredQuicFrames = new ArrayList<QuicFrame>(Arrays.asList(configuredQuicFrames));
    }

    public SendAction(HttpMessage ... httpMessage) {
        this.configuredHttpMessages = new ArrayList<HttpMessage>(Arrays.asList(httpMessage));
    }

    public SendAction(ProtocolMessage ... messages) {
        this(new ArrayList<ProtocolMessage>(Arrays.asList(messages)));
    }

    public SendAction(SSL2Message ... messages) {
        this.configuredSSL2Messages = new ArrayList<SSL2Message>(Arrays.asList(messages));
    }

    public SendAction(String connectionAlias) {
        super(connectionAlias);
    }

    public SendAction(String connectionAlias, List<ProtocolMessage> configuredMessages) {
        super(connectionAlias);
        this.configuredMessages = configuredMessages;
    }

    public SendAction(String connectionAlias, ProtocolMessage ... configuredMessages) {
        this(connectionAlias);
        this.configuredMessages = new ArrayList<ProtocolMessage>(Arrays.asList(configuredMessages));
    }

    public List<ProtocolMessage> getConfiguredMessages() {
        return this.configuredMessages;
    }

    public void setConfiguredMessages(List<ProtocolMessage> configuredMessages) {
        this.configuredMessages = configuredMessages;
    }

    public void setConfiguredMessages(ProtocolMessage ... configuredMessages) {
        this.configuredMessages = new ArrayList<ProtocolMessage>(Arrays.asList(configuredMessages));
    }

    public List<DtlsHandshakeMessageFragment> getConfiguredDtlsHandshakeMessageFragments() {
        return this.configuredDtlsHandshakeMessageFragments;
    }

    public void setConfiguredDtlsHandshakeMessageFragments(List<DtlsHandshakeMessageFragment> configuredDtlsHandshakeMessageFragment) {
        this.configuredDtlsHandshakeMessageFragments = configuredDtlsHandshakeMessageFragment;
    }

    public List<Record> getConfiguredRecords() {
        return this.configuredRecords;
    }

    public void setConfiguredRecords(List<Record> configuredRecords) {
        this.configuredRecords = configuredRecords;
    }

    public void setConfiguredRecords(Record ... configuredRecords) {
        this.configuredRecords = new ArrayList<Record>(Arrays.asList(configuredRecords));
    }

    public List<HttpMessage> getConfiguredHttpMessages() {
        return this.configuredHttpMessages;
    }

    public void setConfiguredHttpMessages(List<HttpMessage> configuredHttpMessages) {
        this.configuredHttpMessages = configuredHttpMessages;
    }

    public List<QuicFrame> getConfiguredQuicFrames() {
        return this.configuredQuicFrames;
    }

    public void setConfiguredQuicFrames(QuicFrame ... configuredQuicFrames) {
        this.configuredQuicFrames = new ArrayList<QuicFrame>(Arrays.asList(configuredQuicFrames));
    }

    public void setConfiguredQuicFrames(List<QuicFrame> configuredQuicFrames) {
        this.configuredQuicFrames = configuredQuicFrames;
    }

    public List<QuicPacket> getConfiguredQuicPackets() {
        return this.configuredQuicPackets;
    }

    public void setConfiguredQuicPackets(QuicPacket ... configuredQuicPackets) {
        this.configuredQuicPackets = new ArrayList<QuicPacket>(Arrays.asList(configuredQuicPackets));
    }

    public void setConfiguredQuicPackets(List<QuicPacket> configuredQuicPackets) {
        this.configuredQuicPackets = configuredQuicPackets;
    }

    public List<SSL2Message> getConfiguredSSL2Messages() {
        return this.configuredSSL2Messages;
    }

    public void setConfiguredSSL2Messages(List<SSL2Message> configuredSSL2Messages) {
        this.configuredSSL2Messages = configuredSSL2Messages;
    }

    public String toString() {
        return "SendAction: " + (this.isExecuted() ? "\n" : "(not executed)\n") + "\tMessages: " + LogPrinter.toHumanReadableMultiLineContainerListArray(this.getConfiguredDataContainerLists(), LOGGER.getLevel());
    }

    @Override
    public String toCompactString() {
        return super.toCompactString() + LogPrinter.toHumanReadableMultiLineContainerListArray(this.getConfiguredDataContainerLists(), LOGGER.getLevel());
    }

    @Override
    public void reset() {
        super.reset();
        LinkedList<ModifiableVariableHolder> holders = new LinkedList<ModifiableVariableHolder>();
        if (this.configuredMessages != null) {
            for (ProtocolMessage protocolMessage : this.configuredMessages) {
                holders.addAll(protocolMessage.getAllModifiableVariableHolders());
            }
        }
        if (this.configuredSSL2Messages != null) {
            for (SSL2Message sSL2Message : this.configuredSSL2Messages) {
                holders.addAll(sSL2Message.getAllModifiableVariableHolders());
            }
        }
        if (this.configuredRecords != null) {
            for (Record record : this.configuredRecords) {
                holders.addAll(record.getAllModifiableVariableHolders());
            }
        }
        if (this.configuredDtlsHandshakeMessageFragments != null) {
            for (DtlsHandshakeMessageFragment dtlsHandshakeMessageFragment : this.configuredDtlsHandshakeMessageFragments) {
                holders.addAll(dtlsHandshakeMessageFragment.getAllModifiableVariableHolders());
            }
        }
        if (this.configuredHttpMessages != null) {
            for (HttpMessage httpMessage : this.configuredHttpMessages) {
                holders.addAll(httpMessage.getAllModifiableVariableHolders());
            }
        }
        if (this.configuredQuicFrames != null) {
            for (QuicFrame quicFrame : this.configuredQuicFrames) {
                holders.addAll(quicFrame.getAllModifiableVariableHolders());
            }
        }
        if (this.configuredQuicPackets != null) {
            for (QuicPacket quicPacket : this.configuredQuicPackets) {
                holders.addAll(quicPacket.getAllModifiableVariableHolders());
            }
        }
        for (ModifiableVariableHolder modifiableVariableHolder : holders) {
            modifiableVariableHolder.reset();
        }
    }

    public List<ProtocolMessageType> getGoingToSendProtocolMessageTypes() {
        ArrayList<ProtocolMessageType> protocolMessageTypes = new ArrayList<ProtocolMessageType>();
        for (ProtocolMessage msg : this.configuredMessages) {
            protocolMessageTypes.add(msg.getProtocolMessageType());
        }
        return protocolMessageTypes;
    }

    public List<HandshakeMessageType> getGoingToSendHandshakeMessageTypes() {
        ArrayList<HandshakeMessageType> handshakeMessageTypes = new ArrayList<HandshakeMessageType>();
        for (ProtocolMessage msg : this.configuredMessages) {
            if (!(msg instanceof HandshakeMessage)) continue;
            handshakeMessageTypes.add(((HandshakeMessage)msg).getHandshakeMessageType());
        }
        return handshakeMessageTypes;
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        LinkedList configurationList = new LinkedList();
        if (this.getConfiguredRecords() != null) {
            configurationList.add(new SpecificSendLayerConfiguration<Record>((LayerType)ImplementedLayers.RECORD, this.getConfiguredRecords()));
        }
        if (this.getConfiguredMessages() != null) {
            configurationList.add(new SpecificSendLayerConfiguration<ProtocolMessage>((LayerType)ImplementedLayers.SSL2, this.getConfiguredMessages()));
            configurationList.add(new SpecificSendLayerConfiguration<ProtocolMessage>((LayerType)ImplementedLayers.MESSAGE, this.getConfiguredMessages()));
        }
        if (this.getConfiguredSSL2Messages() != null) {
            configurationList.add(new SpecificReceiveLayerConfiguration<SSL2Message>((LayerType)ImplementedLayers.SSL2, this.getConfiguredSSL2Messages()));
        }
        if (this.getConfiguredDtlsHandshakeMessageFragments() != null) {
            configurationList.add(new SpecificSendLayerConfiguration<DtlsHandshakeMessageFragment>((LayerType)ImplementedLayers.DTLS_FRAGMENT, this.getConfiguredDtlsHandshakeMessageFragments()));
        }
        if (this.getConfiguredHttpMessages() != null) {
            configurationList.add(new SpecificSendLayerConfiguration<HttpMessage>((LayerType)ImplementedLayers.HTTP, this.getConfiguredHttpMessages()));
        }
        if (this.getConfiguredQuicFrames() != null) {
            configurationList.add(new SpecificSendLayerConfiguration<QuicFrame>((LayerType)ImplementedLayers.QUICFRAME, this.getConfiguredQuicFrames()));
        }
        if (this.getConfiguredQuicPackets() != null) {
            configurationList.add(new SpecificSendLayerConfiguration<QuicPacket>((LayerType)ImplementedLayers.QUICPACKET, this.getConfiguredQuicPackets()));
        }
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), true, this.getActionOptions(), configurationList);
    }

    @Override
    public List<List<DataContainer>> getConfiguredDataContainerLists() {
        LinkedList<List<DataContainer>> dataContainerLists = new LinkedList<List<DataContainer>>();
        if (this.configuredHttpMessages != null) {
            dataContainerLists.add(this.configuredHttpMessages);
        }
        if (this.configuredMessages != null) {
            dataContainerLists.add(this.configuredMessages);
        }
        if (this.configuredDtlsHandshakeMessageFragments != null) {
            dataContainerLists.add(this.configuredDtlsHandshakeMessageFragments);
        }
        if (this.configuredRecords != null) {
            dataContainerLists.add(this.configuredRecords);
        }
        if (this.configuredQuicFrames != null) {
            dataContainerLists.add(this.configuredQuicFrames);
        }
        if (this.configuredQuicPackets != null) {
            dataContainerLists.add(this.configuredQuicPackets);
        }
        if (this.configuredSSL2Messages != null) {
            dataContainerLists.add(this.configuredSSL2Messages);
        }
        return dataContainerLists;
    }
}

